/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.api;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import vswe.stevesfactory.api.capability.CapabilityDocuments;
import vswe.stevesfactory.api.capability.CapabilityEventDispatchers;
import vswe.stevesfactory.api.capability.CapabilityRedstone;
import vswe.stevesfactory.api.logic.IProcedureType;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.MOD)
public class StevesFactoryManagerAPI {
    public static final String MODID = "sfm";
    private static IForgeRegistry<IProcedureType<?>> procedures;
    private static Set<Capability<?>> recognizableCapabilities;

    public static IForgeRegistry<IProcedureType<?>> getProceduresRegistry() {
        if (procedures == null) {
            procedures = RegistryManager.ACTIVE.getRegistry(IProcedureType.class);
        }
        return procedures;
    }

    public static Set<Capability<?>> getRecognizableCapabilities() {
        if (recognizableCapabilities == null) {
            recognizableCapabilities = Sets.newIdentityHashSet();
            recognizableCapabilities.add(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            recognizableCapabilities.add(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            recognizableCapabilities.add(CapabilityRedstone.REDSTONE_CAPABILITY);
            recognizableCapabilities.add(CapabilityEventDispatchers.REDSTONE_EVENT_DISPATCHER_CAPABILITY);
            recognizableCapabilities.add(CapabilityEventDispatchers.BUD_EVENT_DISPATCHER_CAPABILITY);
            recognizableCapabilities.add(CapabilityDocuments.TEXT_DISPLAY_CAPABILITY);
        }
        return recognizableCapabilities;
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        CapabilityRedstone.register();
        CapabilityEventDispatchers.registerRedstone();
        CapabilityEventDispatchers.registerBUD();
        CapabilityDocuments.registerTextDocument();
    }

    @SubscribeEvent
    public static void onRegistryCreation(RegistryEvent.NewRegistry event) {
        StevesFactoryManagerAPI.makeRegistry(new ResourceLocation(MODID, "procedures"), IProcedureType.class).create();
    }

    private static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistry(ResourceLocation name, Class<T> type) {
        return new RegistryBuilder().setName(name).setType(type);
    }
}

