/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.generators.client.model.ModelBioGenerator;
import mekanism.generators.common.registries.GeneratorsFluids;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class RenderBioGenerator
extends MekanismTileEntityRenderer<TileEntityBioGenerator> {
    private static final Map<Direction, Int2ObjectMap<MekanismRenderer.Model3D>> energyDisplays = new EnumMap<Direction, Int2ObjectMap<MekanismRenderer.Model3D>>(Direction.class);
    private static final int stages = 40;
    private final ModelBioGenerator model = new ModelBioGenerator();

    public static void resetCachedModels() {
        energyDisplays.clear();
    }

    public RenderBioGenerator(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    protected void render(TileEntityBioGenerator tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        if (!tile.bioFuelTank.isEmpty()) {
            matrix.func_227860_a_();
            FluidStack fluid = tile.bioFuelTank.getFluid();
            float fluidScale = (float)fluid.getAmount() / (float)tile.bioFuelTank.getCapacity();
            MekanismRenderer.renderObject((MekanismRenderer.Model3D)this.getModel(tile.getDirection(), (int)(fluidScale * 39.0f)), (MatrixStack)matrix, (IVertexBuilder)renderer.getBuffer(MekanismRenderType.resizableCuboid()), (int)MekanismRenderer.getColorARGB((FluidStack)fluid, (float)fluidScale), (int)MekanismRenderer.calculateGlowLight((int)light, (FluidStack)fluid));
            matrix.func_227865_b_();
        }
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 1.5, 0.5);
        MekanismRenderer.rotate((MatrixStack)matrix, (Direction)tile.getDirection(), (float)180.0f, (float)0.0f, (float)270.0f, (float)90.0f);
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        this.model.render(matrix, renderer, light, overlayLight);
        matrix.func_227865_b_();
    }

    protected String getProfilerSection() {
        return "bioGenerator";
    }

    private MekanismRenderer.Model3D getModel(Direction side, int stage) {
        if (energyDisplays.containsKey(side) && energyDisplays.get(side).containsKey(stage)) {
            return (MekanismRenderer.Model3D)energyDisplays.get(side).get(stage);
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        model.setTexture(MekanismRenderer.getFluidTexture((FluidStack)GeneratorsFluids.BIOETHANOL.getFluidStack(1), (MekanismRenderer.FluidType)MekanismRenderer.FluidType.STILL));
        switch (side) {
            case NORTH: {
                model.minZ = 0.5;
                model.maxZ = 0.875;
                model.minX = 0.1875;
                model.maxX = 0.8215;
                break;
            }
            case SOUTH: {
                model.minZ = 0.125;
                model.maxZ = 0.5;
                model.minX = 0.1875;
                model.maxX = 0.8215;
                break;
            }
            case WEST: {
                model.minX = 0.5;
                model.maxX = 0.875;
                model.minZ = 0.1875;
                model.maxZ = 0.8215;
                break;
            }
            case EAST: {
                model.minX = 0.125;
                model.maxX = 0.5;
                model.minZ = 0.1875;
                model.maxZ = 0.8215;
            }
        }
        model.minY = 0.4385;
        model.maxY = 0.4375 + (double)((float)stage / 40.0f) * 0.4375 + 0.001;
        if (energyDisplays.containsKey(side)) {
            energyDisplays.get(side).put(stage, (Object)model);
        } else {
            Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
            map.put(stage, (Object)model);
            energyDisplays.put(side, (Int2ObjectMap<MekanismRenderer.Model3D>)map);
        }
        return model;
    }
}

