/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.SimpleModelFontRenderer;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.common.ForgeConfig;

final class FancyMissingModel
implements IUnbakedModel {
    private static final ResourceLocation font = new ResourceLocation("minecraft", "textures/font/ascii.png");
    private static final Material font2 = new Material(AtlasTexture.field_110575_b, new ResourceLocation("minecraft", "font/ascii"));
    private static final TransformationMatrix smallTransformation = new TransformationMatrix(null, null, new Vector3f(0.25f, 0.25f, 0.25f), null).blockCenterToCorner();
    private static final SimpleModelFontRenderer fontRenderer = (SimpleModelFontRenderer)((Object)Util.func_199748_a(() -> {
        float[] mv = new float[16];
        mv[8] = 0.0078125f;
        mv[1] = mv[6] = -mv[8];
        mv[15] = 1.0f;
        mv[3] = 1.0f;
        mv[3] = 1.0039062f;
        mv[3] = 0.0f;
        Matrix4f m = new Matrix4f(mv);
        return new SimpleModelFontRenderer(Minecraft.func_71410_x().field_71474_y, font, Minecraft.func_71410_x().func_110434_K(), false, m){};
    }));
    private final IUnbakedModel missingModel;
    private final String message;

    public FancyMissingModel(IUnbakedModel missingModel, String message) {
        this.missingModel = missingModel;
        this.message = message;
    }

    public Collection<Material> func_225614_a_(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return ImmutableList.of((Object)font2);
    }

    public Collection<ResourceLocation> func_187965_e() {
        return Collections.emptyList();
    }

    @Nullable
    public IBakedModel func_225613_a_(ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) {
        IBakedModel bigMissing = this.missingModel.func_225613_a_(bakery, spriteGetter, modelTransform, modelLocation);
        ModelTransformComposition smallState = new ModelTransformComposition(modelTransform, new SimpleModelTransform(smallTransformation));
        IBakedModel smallMissing = this.missingModel.func_225613_a_(bakery, spriteGetter, (IModelTransform)smallState, modelLocation);
        return new BakedModel(bigMissing, smallMissing, fontRenderer, this.message, spriteGetter.apply(font2));
    }

    static final class BakedModel
    implements IBakedModel {
        private final SimpleModelFontRenderer fontRenderer;
        private final String message;
        private final TextureAtlasSprite fontTexture;
        private final IBakedModel missingModel;
        private final IBakedModel otherModel;
        private final boolean big;
        private ImmutableList<BakedQuad> quads;

        public BakedModel(IBakedModel bigMissing, IBakedModel smallMissing, SimpleModelFontRenderer fontRenderer, String message, TextureAtlasSprite fontTexture) {
            this.missingModel = bigMissing;
            this.otherModel = new BakedModel(smallMissing, fontRenderer, message, fontTexture, this);
            this.big = true;
            this.fontRenderer = fontRenderer;
            this.message = message;
            this.fontTexture = fontTexture;
        }

        public BakedModel(IBakedModel smallMissing, SimpleModelFontRenderer fontRenderer, String message, TextureAtlasSprite fontTexture, BakedModel big) {
            this.missingModel = smallMissing;
            this.otherModel = big;
            this.big = false;
            this.fontRenderer = fontRenderer;
            this.message = message;
            this.fontTexture = fontTexture;
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            if (side == null) {
                if (this.quads == null) {
                    int y;
                    this.fontRenderer.setSprite(this.fontTexture);
                    this.fontRenderer.setFillBlanks(true);
                    String[] lines = this.message.split("\\r?\\n");
                    ArrayList splitLines = Lists.newArrayList();
                    for (y = 0; y < lines.length; ++y) {
                        splitLines.addAll(this.fontRenderer.func_78271_c(lines[y], 128));
                    }
                    for (y = 0; y < splitLines.size(); ++y) {
                        String string = (String)splitLines.get(y);
                        float f = (float)y - (float)splitLines.size() / 2.0f;
                        ((Object)((Object)this.fontRenderer)).getClass();
                        this.fontRenderer.func_211126_b(string, 0.0f, f * 9.0f + 64.0f, -16711681);
                    }
                    ImmutableList.Builder builder = ImmutableList.builder();
                    builder.addAll((Iterable)this.missingModel.func_200117_a(state, side, rand));
                    builder.addAll(this.fontRenderer.build());
                    this.quads = builder.build();
                }
                return this.quads;
            }
            return this.missingModel.func_200117_a(state, side, rand);
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_230044_c_() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.fontTexture;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
            TransformationMatrix transform = TransformationMatrix.func_227983_a_();
            boolean big = true;
            switch (cameraTransformType) {
                case THIRD_PERSON_LEFT_HAND: {
                    break;
                }
                case THIRD_PERSON_RIGHT_HAND: {
                    break;
                }
                case FIRST_PERSON_LEFT_HAND: {
                    transform = new TransformationMatrix(new Vector3f(-0.62f, 0.5f, -0.5f), new Quaternion(1.0f, -1.0f, -1.0f, 1.0f), null, null);
                    big = false;
                    break;
                }
                case FIRST_PERSON_RIGHT_HAND: {
                    transform = new TransformationMatrix(new Vector3f(-0.5f, 0.5f, -0.5f), new Quaternion(1.0f, 1.0f, 1.0f, 1.0f), null, null);
                    big = false;
                    break;
                }
                case HEAD: {
                    break;
                }
                case GUI: {
                    if (((Boolean)ForgeConfig.CLIENT.zoomInMissingModelTextInGui.get()).booleanValue()) {
                        transform = new TransformationMatrix(null, new Quaternion(1.0f, 1.0f, 1.0f, 1.0f), new Vector3f(4.0f, 4.0f, 4.0f), null);
                        big = false;
                        break;
                    }
                    transform = new TransformationMatrix(null, new Quaternion(1.0f, 1.0f, 1.0f, 1.0f), null, null);
                    big = true;
                    break;
                }
                case FIXED: {
                    transform = new TransformationMatrix(null, new Quaternion(-1.0f, -1.0f, 1.0f, 1.0f), null, null);
                    break;
                }
            }
            mat.func_227866_c_().func_227870_a_().func_226595_a_(transform.func_227988_c_());
            if (big != this.big) {
                return this.otherModel;
            }
            return this;
        }
    }
}

