/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.packingtape.tape;

import gigaherz.packingtape.PackingTapeMod;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.registries.ObjectHolder;

public class PackagedBlockEntity
extends TileEntity {
    @ObjectHolder(value="packingtape:packaged_block")
    public static TileEntityType<PackagedBlockEntity> TYPE;
    private BlockState containedBlockState;
    private CompoundNBT containedTile;
    private Direction preferredDirection;

    public PackagedBlockEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public PackagedBlockEntity() {
        super(TYPE);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        if (this.containedBlockState != null) {
            CompoundNBT blockData = NBTUtil.func_190009_a((BlockState)this.containedBlockState);
            compound.func_218657_a("Block", (INBT)blockData);
            compound.func_218657_a("BlockEntity", (INBT)this.containedTile.func_74737_b());
            if (this.preferredDirection != null) {
                compound.func_74768_a("PreferredDirection", this.preferredDirection.ordinal());
            }
        }
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("containedBlock", 8)) {
            CompoundNBT tempTag = new CompoundNBT();
            tempTag.func_74778_a("Name", compound.func_74779_i("containedBlock"));
            tempTag.func_218657_a("Properties", compound.func_74781_a("containedBlockState"));
            this.containedBlockState = NBTUtil.func_190008_d((CompoundNBT)tempTag);
            this.containedTile = compound.func_74775_l("containedTile").func_74737_b();
            if (compound.func_74764_b("preferredDirection")) {
                this.preferredDirection = Direction.values()[compound.func_74762_e("preferredDirection")];
            }
        } else {
            CompoundNBT blockTag = compound.func_74775_l("Block");
            this.containedBlockState = NBTUtil.func_190008_d((CompoundNBT)blockTag);
            this.containedTile = compound.func_74775_l("BlockEntity").func_74737_b();
            if (compound.func_74764_b("PreferredDirection")) {
                this.preferredDirection = Direction.func_176739_a((String)compound.func_74779_i("PreferredDirection"));
            }
        }
    }

    public BlockState getContainedBlockState() {
        return this.containedBlockState;
    }

    public CompoundNBT getContainedTile() {
        return this.containedTile;
    }

    public void setContents(BlockState state, CompoundNBT tag) {
        this.containedBlockState = state;
        this.containedTile = tag;
    }

    @Nullable
    public Direction getPreferredDirection() {
        return this.preferredDirection;
    }

    public void setPreferredDirection(Direction preferredDirection) {
        this.preferredDirection = preferredDirection;
    }

    public ItemStack getPackedStack() {
        ItemStack stack = new ItemStack((IItemProvider)PackingTapeMod.PACKAGED_BLOCK.get());
        CompoundNBT tileEntityData = new CompoundNBT();
        this.func_189515_b(tileEntityData);
        tileEntityData.func_82580_o("x");
        tileEntityData.func_82580_o("y");
        tileEntityData.func_82580_o("z");
        CompoundNBT stackTag = new CompoundNBT();
        stackTag.func_218657_a("BlockEntityTag", (INBT)tileEntityData);
        stack.func_77982_d(stackTag);
        PackingTapeMod.logger.debug(String.format("Created Packed stack with %s", this.containedBlockState.toString()));
        return stack;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.func_145839_a(tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public boolean isEmpty() {
        return this.containedBlockState == null || this.containedBlockState.func_196958_f();
    }
}

