/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.ArrayConverter;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.Category;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.Config;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.ConfigException;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.TypeAdapter;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.TypeAdapters;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

final class Property {
    private final Field field;
    private final String fullyQualifiedName;
    private final String languageKey;
    private final String previous;
    private final TypeAdapter adapter;
    private final boolean isArray;
    private final Class<?> enumClass;
    private final Enum[] enumConstants;
    private final String[] validValues;
    private final String[] validValuesDisplay;
    private final boolean nonNull;
    private final double min;
    private final double max;
    private final String[] blacklist;
    private final String comment;
    private final boolean requiresRestart;
    private final boolean requiresReload;
    private Object defaultValue;

    Property(Category category, String name, Field field, String comment, String previous) {
        double largestMax;
        double smallestMin;
        Object defaultValue;
        this.field = field;
        this.fullyQualifiedName = category.getFullyQualifiedName() + "." + name;
        this.languageKey = category.getLanguageKeyPrefix() + name;
        this.previous = previous;
        Class<?> clazz = field.getType();
        if (Enum.class.isAssignableFrom(clazz)) {
            this.enumClass = clazz;
            this.adapter = TypeAdapters.get(String.class);
        } else if (Enum[].class.isAssignableFrom(clazz)) {
            this.enumClass = clazz.getComponentType();
            this.adapter = TypeAdapters.get(String[].class);
        } else {
            this.enumClass = null;
            this.adapter = TypeAdapters.get(clazz);
        }
        if (this.adapter == null) {
            throw new ConfigException(name, new UnsupportedOperationException("Invalid configuration property type: " + clazz.getName()));
        }
        if (this.enumClass == null) {
            this.enumConstants = null;
            this.validValues = null;
            this.validValuesDisplay = null;
        } else {
            ArrayList<String> validValues = new ArrayList<String>();
            ArrayList<String> validValuesDisplay = new ArrayList<String>();
            for (Enum element : this.enumConstants = (Enum[])this.enumClass.getEnumConstants()) {
                validValues.add(element.name());
                validValuesDisplay.add(element.toString());
            }
            this.validValues = validValues.toArray(new String[0]);
            this.validValuesDisplay = validValuesDisplay.toArray(new String[0]);
        }
        this.isArray = this.adapter.isArray();
        try {
            defaultValue = field.get(null);
        }
        catch (IllegalAccessException ex) {
            throw ConfigException.property(name, ex);
        }
        boolean bl = this.nonNull = field.getAnnotation(Config.NonNull.class) != null;
        if (defaultValue == null && (!this.adapter.canBeNull() || this.nonNull)) {
            throw new ConfigException("Default value of configuration property of type " + clazz.getName() + " may not be null");
        }
        this.defaultValue = defaultValue;
        this.requiresRestart = field.getAnnotation(Config.RequiresRestart.class) != null;
        boolean bl2 = this.requiresReload = field.getAnnotation(Config.RequiresReload.class) != null;
        if (this.requiresRestart && this.requiresReload) {
            throw new ConfigException("The property " + name + " cannot both require a restart and a reload");
        }
        if (defaultValue instanceof Byte) {
            smallestMin = -128.0;
            largestMax = 127.0;
        } else if (defaultValue instanceof Float) {
            smallestMin = -3.4028234663852886E38;
            largestMax = 3.4028234663852886E38;
        } else if (defaultValue instanceof Integer) {
            smallestMin = -2.147483648E9;
            largestMax = 2.147483647E9;
        } else if (defaultValue instanceof Long) {
            smallestMin = -9.223372036854776E18;
            largestMax = 9.223372036854776E18;
        } else if (defaultValue instanceof Short) {
            smallestMin = -32768.0;
            largestMax = 32767.0;
        } else {
            smallestMin = -1.7976931348623157E308;
            largestMax = Double.MAX_VALUE;
        }
        Config.RangeInt rangeInt = field.getAnnotation(Config.RangeInt.class);
        Config.RangeDouble rangeDouble = field.getAnnotation(Config.RangeDouble.class);
        double min = -1.7976931348623157E308;
        double max = Double.MAX_VALUE;
        if (rangeInt != null) {
            if (rangeDouble != null) {
                throw new ConfigException("Two ranges cannot be defined for property " + name);
            }
            min = rangeInt.min();
            max = rangeInt.max();
            if (min == -2.147483648E9 && min < smallestMin) {
                min = smallestMin;
            }
            if (max == 2.147483647E9 && max > largestMax) {
                max = largestMax;
            }
            if (min > max) {
                throw new ConfigException("min cannot be larger than max for property " + name);
            }
        } else if (rangeDouble != null) {
            min = rangeDouble.min();
            max = rangeDouble.max();
            if (min == -1.7976931348623157E308) {
                min = smallestMin;
            }
            if (max == Double.MAX_VALUE) {
                max = largestMax;
            }
            if (min > max) {
                throw new ConfigException("min cannot be larger than max");
            }
        }
        if (min == -1.7976931348623157E308) {
            min = smallestMin;
        }
        if (max == Double.MAX_VALUE) {
            max = largestMax;
        }
        if (min < smallestMin) {
            throw new ConfigException(String.format("min is too small: %s < %s", min, smallestMin));
        }
        if (max > largestMax) {
            throw new ConfigException(String.format("max is too large: %s > %s", max, largestMax));
        }
        this.min = min;
        this.max = max;
        Config.Blacklist blacklist = field.getAnnotation(Config.Blacklist.class);
        String[] stringArray = this.blacklist = blacklist == null ? new String[]{} : blacklist.value();
        if (this.isArray) {
            for (Object element : ArrayConverter.toBoxedArray(defaultValue)) {
                if (!ArrayUtils.contains((Object[])this.blacklist, (Object)this.adapter.asString(element))) continue;
                throw new ConfigException("Default value is blacklisted");
            }
        } else if (ArrayUtils.contains((Object[])this.blacklist, (Object)this.adapter.asString(defaultValue))) {
            throw new ConfigException("Default value is blacklisted");
        }
        StringBuilder commentBuilder = new StringBuilder(comment);
        if (this.enumConstants != null) {
            commentBuilder.append("\n Valid values:");
            for (Enum element : this.enumConstants) {
                commentBuilder.append("\n ").append(element.name());
            }
        }
        if (defaultValue instanceof Number) {
            if (defaultValue instanceof Double || defaultValue instanceof Float) {
                commentBuilder.append("\n Min: ").append(min).append("\n Max: ").append(max);
            } else {
                commentBuilder.append("\n Min: ").append((long)min).append("\n Max: ").append((long)max);
            }
        }
        if (this.blacklist.length != 0) {
            commentBuilder.append("\n Blacklist: ").append(Arrays.toString(this.blacklist));
        }
        commentBuilder.append("\n Default: ");
        if (this.isArray) {
            commentBuilder.append(Arrays.stream(ArrayConverter.toBoxedArray(defaultValue)).map(this.adapter::asString).collect(Collectors.toList()));
        } else {
            commentBuilder.append(this.adapter.asString(defaultValue));
        }
        this.comment = commentBuilder.toString();
    }

    public boolean requiresRestart() {
        return this.requiresRestart;
    }

    public boolean requiresReload() {
        return this.requiresReload;
    }

    String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    String getLanguageKey() {
        return this.languageKey;
    }

    String[] getValidValues() {
        return (String[])this.validValues.clone();
    }

    String[] getValidValuesDisplay() {
        return (String[])this.validValuesDisplay.clone();
    }

    boolean shouldLoad() {
        return this.adapter.shouldLoad();
    }

    void reloadDefault() {
        this.defaultValue = this.adapter.reloadDefault(this.defaultValue);
    }

    boolean exists(CommentedFileConfig config) {
        return config.contains(this.fullyQualifiedName) || this.previous != null && config.contains(this.previous);
    }

    Object get(CommentedFileConfig config) {
        if (!config.contains(this.fullyQualifiedName)) {
            if (this.previous != null && config.contains(this.previous)) {
                config.set(this.fullyQualifiedName, config.get(this.previous));
            } else {
                this.set(config, this.defaultValue);
            }
        }
        this.set(config, this.adapter.getValue(config, this.fullyQualifiedName, this.defaultValue));
        return this.adapter.getValue(config, this.fullyQualifiedName, this.defaultValue);
    }

    String getAsString(CommentedFileConfig config) {
        return this.adapter.asString(this.get(config));
    }

    void set(CommentedFileConfig config, Object value) {
        config.setComment(this.fullyQualifiedName, this.comment);
        this.adapter.setValue(config, this.fullyQualifiedName, this.validate(value, this.isArray));
    }

    Object validate(Object value, boolean isArray) {
        if (value == null && (!this.adapter.canBeNull() || this.nonNull)) {
            value = this.defaultValue;
        }
        if (isArray) {
            boolean primitive = !(value instanceof Object[]);
            Object[] boxedArray = ArrayConverter.toBoxedArray(value);
            ArrayList<Object> filtered = new ArrayList<Object>();
            for (Object element : boxedArray) {
                Object validated;
                if (element == null || (validated = this.validate(element, false)) == null) continue;
                filtered.add(validated);
            }
            Object[] filteredArray = filtered.toArray(Arrays.copyOf(boxedArray, 0));
            return primitive ? ArrayConverter.toPrimitiveArray(filteredArray) : filteredArray;
        }
        if (ArrayUtils.contains((Object[])this.blacklist, (Object)this.adapter.asString(value))) {
            return null;
        }
        if (value instanceof Number) {
            double number = ((Number)value).doubleValue();
            if (number < this.min) {
                number = this.min;
            } else if (number > this.max) {
                number = this.max;
            }
            if (value instanceof Byte) {
                return (byte)number;
            }
            if (value instanceof Double) {
                return number;
            }
            if (value instanceof Float) {
                return Float.valueOf((float)number);
            }
            if (value instanceof Integer) {
                return (int)number;
            }
            if (value instanceof Long) {
                return (long)number;
            }
            if (value instanceof Short) {
                return (short)number;
            }
        }
        return value;
    }

    void serialize(CommentedFileConfig config) throws IllegalAccessException {
        Object value = this.validate(this.field.get(null), this.isArray);
        if (value == null) {
            value = this.defaultValue;
        }
        if (this.enumConstants == null) {
            this.set(config, value);
        } else if (!this.isArray) {
            this.set(config, ((Enum)value).name());
        } else {
            this.set(config, Arrays.stream((Enum[])value).map(Enum::name).toArray(String[]::new));
        }
    }

    void deserialize(CommentedFileConfig config) throws IllegalAccessException {
        if (this.enumConstants == null) {
            Object value = this.get(config);
            if (this.nonNull && value == null) {
                this.field.set(null, this.defaultValue);
            } else {
                Object validated = this.validate(value, this.isArray);
                this.field.set(null, validated == null ? this.defaultValue : validated);
            }
            return;
        }
        if (!this.isArray) {
            String value = StringUtils.remove((String)this.getAsString(config), (char)'_');
            for (Enum element : this.enumConstants) {
                if (!StringUtils.remove((String)element.name(), (char)'_').equalsIgnoreCase(value)) continue;
                this.field.set(null, element);
                return;
            }
            this.field.set(null, this.defaultValue);
            return;
        }
        String[] values = (String[])this.get(config);
        ArrayList<Enum> enumValues = new ArrayList<Enum>(values.length);
        block1: for (String value : values) {
            value = StringUtils.remove((String)value, (char)'_');
            for (Enum element : this.enumConstants) {
                if (!StringUtils.remove((String)element.name(), (char)'_').equalsIgnoreCase(value)) continue;
                enumValues.add(element);
                continue block1;
            }
        }
        this.field.set(null, enumValues.toArray((Object[])Array.newInstance(this.enumClass, 0)));
    }
}

