/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.mixin.chunk.light;

import me.jellysquid.mods.phosphor.common.chunk.light.LevelBasedGraphExtended;
import me.jellysquid.mods.phosphor.common.chunk.light.LightEngineExtended;
import me.jellysquid.mods.phosphor.common.util.LightUtil;
import me.jellysquid.mods.phosphor.common.util.math.ChunkSectionPosHelper;
import me.jellysquid.mods.phosphor.common.util.math.DirectionHelper;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.lighting.SectionLightStorage;
import net.minecraft.world.lighting.SkyLightEngine;
import net.minecraft.world.lighting.SkyLightStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={SkyLightEngine.class})
public abstract class MixinSkyLightEngine
extends LightEngine<SkyLightStorage.StorageMap, SkyLightStorage>
implements LevelBasedGraphExtended,
LightEngineExtended {
    @Shadow
    @Final
    private static Direction[] field_215634_e;
    @Shadow
    @Final
    private static Direction[] field_215633_d;

    public MixinSkyLightEngine(IChunkLightProvider lightProvider, LightType lightType, SkyLightStorage storage) {
        super(lightProvider, lightType, (SectionLightStorage)storage);
    }

    @Overwrite
    public int func_215480_b(long fromId, long toId, int currentLevel) {
        return this.getEdgeLevel(fromId, null, toId, currentLevel);
    }

    @Override
    public int getEdgeLevel(long fromId, BlockState fromState, long toId, int currentLevel) {
        int toZ;
        int toY;
        if (toId == Long.MAX_VALUE) {
            return 15;
        }
        if (fromId == Long.MAX_VALUE) {
            if (((SkyLightStorage)this.field_215627_c).func_215551_l(toId)) {
                currentLevel = 0;
            } else {
                return 15;
            }
        }
        if (currentLevel >= 15) {
            return currentLevel;
        }
        int toX = BlockPos.func_218290_b((long)toId);
        BlockState toState = this.getBlockStateForLighting(toX, toY = BlockPos.func_218274_c((long)toId), toZ = BlockPos.func_218282_d((long)toId));
        if (toState == null) {
            return 15;
        }
        int fromX = BlockPos.func_218290_b((long)fromId);
        int fromY = BlockPos.func_218274_c((long)fromId);
        int fromZ = BlockPos.func_218282_d((long)fromId);
        if (fromState == null) {
            fromState = this.getBlockStateForLighting(fromX, fromY, fromZ);
        }
        boolean verticalOnly = fromX == toX && fromZ == toZ;
        Direction dir = fromId == Long.MAX_VALUE ? Direction.DOWN : DirectionHelper.getVecDirection(toX - fromX, toY - fromY, toZ - fromZ);
        if (dir != null) {
            VoxelShape fromShape;
            VoxelShape toShape = this.getOpaqueShape(toState, toX, toY, toZ, dir.func_176734_d());
            if (toShape != VoxelShapes.func_197868_b() && LightUtil.faceShapeCovers(fromShape = this.getOpaqueShape(fromState, fromX, fromY, fromZ, dir), toShape)) {
                return 15;
            }
        } else {
            Direction altDir = Direction.func_218383_a((int)(toX - fromX), (int)(verticalOnly ? -1 : 0), (int)(toZ - fromZ));
            if (altDir == null) {
                return 15;
            }
            VoxelShape toShape = this.getOpaqueShape(toState, toX, toY, toZ, altDir.func_176734_d());
            if (LightUtil.faceShapeCovers(VoxelShapes.func_197880_a(), toShape)) {
                return 15;
            }
            VoxelShape fromShape = this.getOpaqueShape(fromState, fromX, fromY, fromZ, Direction.DOWN);
            if (LightUtil.faceShapeCovers(fromShape, VoxelShapes.func_197880_a())) {
                return 15;
            }
        }
        int out = this.getSubtractedLight(toState, toX, toY, toZ);
        if ((fromId == Long.MAX_VALUE || verticalOnly && fromY > toY) && currentLevel == 0 && out == 0) {
            return 0;
        }
        return currentLevel + Math.max(1, out);
    }

    @Overwrite
    public void func_215478_a(long id, int targetLevel, boolean mergeAsMin) {
        int aboveY;
        int aboveChunkY;
        int belowY;
        int belowChunkY;
        long chunkId = SectionPos.func_218162_e((long)id);
        int x = BlockPos.func_218290_b((long)id);
        int y = BlockPos.func_218274_c((long)id);
        int z = BlockPos.func_218282_d((long)id);
        int localX = SectionPos.func_218171_b((int)x);
        int localY = SectionPos.func_218171_b((int)y);
        int localZ = SectionPos.func_218171_b((int)z);
        BlockState fromState = this.getBlockStateForLighting(x, y, z);
        if (localX > 0 && localX < 15 && localY > 0 && localY < 15 && localZ > 0 && localZ < 15) {
            for (Direction dir : field_215633_d) {
                this.notifyNeighbors(id, fromState, BlockPos.func_218276_a((int)(x + dir.func_82601_c()), (int)(y + dir.func_96559_d()), (int)(z + dir.func_82599_e())), targetLevel, mergeAsMin);
            }
            return;
        }
        int chunkY = SectionPos.func_218159_a((int)y);
        int chunkOffsetY = 0;
        if (localY == 0) {
            while (!((SkyLightStorage)this.field_215627_c).func_215518_g(SectionPos.func_218174_a((long)chunkId, (int)0, (int)(-chunkOffsetY - 1), (int)0)) && ((SkyLightStorage)this.field_215627_c).func_215550_a(chunkY - chunkOffsetY - 1)) {
                ++chunkOffsetY;
            }
        }
        if (chunkY == (belowChunkY = SectionPos.func_218159_a((int)(belowY = y + (-1 - chunkOffsetY * 16)))) || ((SkyLightStorage)this.field_215627_c).func_215518_g(ChunkSectionPosHelper.updateYLong(chunkId, belowChunkY))) {
            this.notifyNeighbors(id, fromState, BlockPos.func_218276_a((int)x, (int)belowY, (int)z), targetLevel, mergeAsMin);
        }
        if (chunkY == (aboveChunkY = SectionPos.func_218159_a((int)(aboveY = y + 1))) || ((SkyLightStorage)this.field_215627_c).func_215518_g(ChunkSectionPosHelper.updateYLong(chunkId, aboveChunkY))) {
            this.notifyNeighbors(id, fromState, BlockPos.func_218276_a((int)x, (int)aboveY, (int)z), targetLevel, mergeAsMin);
        }
        for (Direction dir : field_215634_e) {
            boolean flag;
            int adjX = x + dir.func_82601_c();
            int adjZ = z + dir.func_82599_e();
            int offsetY = 0;
            do {
                int adjY;
                long offsetId;
                long offsetChunkId;
                boolean bl = flag = chunkId == (offsetChunkId = SectionPos.func_218162_e((long)(offsetId = BlockPos.func_218276_a((int)adjX, (int)(adjY = y - offsetY), (int)adjZ))));
                if (!flag && !((SkyLightStorage)this.field_215627_c).func_215518_g(offsetChunkId)) continue;
                this.notifyNeighbors(id, fromState, offsetId, targetLevel, mergeAsMin);
            } while (!flag && ++offsetY <= chunkOffsetY * 16);
        }
    }
}

