/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.gui;

import betteradvancements.advancements.BetterDisplayInfo;
import betteradvancements.advancements.BetterDisplayInfoRegistry;
import betteradvancements.gui.BetterAdvancementEntryGui;
import betteradvancements.gui.BetterAdvancementTabType;
import betteradvancements.gui.BetterAdvancementsScreen;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BetterAdvancementTabGui
extends AbstractGui {
    public static boolean doFade = true;
    private final Minecraft minecraft;
    private final BetterAdvancementsScreen screen;
    private final BetterAdvancementTabType type;
    private final int index;
    private final Advancement advancement;
    private final DisplayInfo display;
    private final ItemStack icon;
    private final String title;
    private final BetterAdvancementEntryGui root;
    protected final Map<Advancement, BetterAdvancementEntryGui> guis = Maps.newLinkedHashMap();
    private final BetterDisplayInfoRegistry betterDisplayInfos;
    protected int scrollX;
    protected int scrollY;
    private int minX = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private float fade;
    private boolean centered;

    public BetterAdvancementTabGui(Minecraft mc, BetterAdvancementsScreen betterAdvancementsScreen, BetterAdvancementTabType type, int index, Advancement advancement, DisplayInfo displayInfo) {
        this.minecraft = mc;
        this.screen = betterAdvancementsScreen;
        this.type = type;
        this.index = index;
        this.advancement = advancement;
        this.display = displayInfo;
        this.icon = displayInfo.func_192298_b();
        this.title = displayInfo.func_192297_a().func_150254_d();
        this.betterDisplayInfos = new BetterDisplayInfoRegistry(advancement);
        this.root = new BetterAdvancementEntryGui(this, mc, advancement, displayInfo);
        this.addGuiAdvancement(this.root, advancement);
    }

    public Advancement getAdvancement() {
        return this.advancement;
    }

    public String getTitle() {
        return this.title;
    }

    public void drawTab(int left, int top, int width, int height, boolean selected) {
        this.type.draw(this, left, top, width, height, selected, this.index);
    }

    public void drawIcon(int left, int top, int width, int height, ItemRenderer renderItem) {
        this.type.drawIcon(left, top, width, height, this.index, renderItem, this.icon);
    }

    public void drawContents(int width, int height) {
        if (!this.centered) {
            this.scrollX = (width - (this.maxX + this.minX)) / 2;
            this.scrollY = (height - (this.maxY + this.minY)) / 2;
            this.centered = true;
        }
        RenderSystem.depthFunc((int)518);
        BetterAdvancementTabGui.fill((int)0, (int)0, (int)width, (int)height, (int)-16777216);
        RenderSystem.depthFunc((int)515);
        ResourceLocation resourcelocation = this.display.func_192293_c();
        if (resourcelocation != null) {
            this.minecraft.func_110434_K().func_110577_a(resourcelocation);
        } else {
            this.minecraft.func_110434_K().func_110577_a(TextureManager.field_194008_a);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.scrollX % 16;
        int j = this.scrollY % 16;
        for (int k = -1; k <= 1 + width / 16; ++k) {
            int l;
            for (l = -1; l <= height / 16; ++l) {
                BetterAdvancementTabGui.blit((int)(i + 16 * k), (int)(j + 16 * l), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
            BetterAdvancementTabGui.blit((int)(i + 16 * k), (int)(j + 16 * l), (float)0.0f, (float)0.0f, (int)16, (int)(height % 16), (int)16, (int)16);
        }
        this.root.drawConnectivity(this.scrollX, this.scrollY, true);
        this.root.drawConnectivity(this.scrollX, this.scrollY, false);
        this.root.draw(this.scrollX, this.scrollY);
    }

    public void drawToolTips(int mouseX, int mouseY, int left, int top, int width, int height) {
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)200.0);
        BetterAdvancementTabGui.fill((int)0, (int)0, (int)width, (int)height, (int)(MathHelper.func_76141_d((float)(this.fade * 255.0f)) << 24));
        boolean flag = false;
        if (mouseX > 0 && mouseX < width && mouseY > 0 && mouseY < height) {
            for (BetterAdvancementEntryGui betterAdvancementEntryGui : this.guis.values()) {
                if (!betterAdvancementEntryGui.isMouseOver(this.scrollX, this.scrollY, mouseX, mouseY)) continue;
                flag = true;
                betterAdvancementEntryGui.drawHover(this.scrollX, this.scrollY, this.fade, left, top);
                break;
            }
        }
        RenderSystem.popMatrix();
        this.fade = doFade && flag ? MathHelper.func_76131_a((float)(this.fade + 0.02f), (float)0.0f, (float)0.3f) : MathHelper.func_76131_a((float)(this.fade - 0.04f), (float)0.0f, (float)1.0f);
    }

    public boolean isMouseOver(int left, int top, int width, int height, double mouseX, double mouseY) {
        return this.type.isMouseOver(left, top, width, height, this.index, mouseX, mouseY);
    }

    @Nullable
    public static BetterAdvancementTabGui create(Minecraft mc, BetterAdvancementsScreen betterAdvancementsScreen, int index, Advancement advancement, int width, int height) {
        if (advancement.func_192068_c() == null) {
            return null;
        }
        BetterAdvancementTabType advancementTabType = BetterAdvancementTabType.getTabType(width, height, index);
        if (advancementTabType == null) {
            return null;
        }
        return new BetterAdvancementTabGui(mc, betterAdvancementsScreen, advancementTabType, index, advancement, advancement.func_192068_c());
    }

    public void scroll(double scrollX, double scrollY, int width, int height) {
        if (this.maxX - this.minX > width) {
            this.scrollX = (int)Math.round(MathHelper.func_151237_a((double)((double)this.scrollX + scrollX), (double)(-(this.maxX - width)), (double)(-this.minX)));
        }
        if (this.maxY - this.minY > height) {
            this.scrollY = (int)Math.round(MathHelper.func_151237_a((double)((double)this.scrollY + scrollY), (double)(-(this.maxY - height)), (double)(-this.minY)));
        }
    }

    public void addAdvancement(Advancement advancement) {
        if (advancement.func_192068_c() != null) {
            BetterAdvancementEntryGui betterAdvancementEntryGui = new BetterAdvancementEntryGui(this, this.minecraft, advancement, advancement.func_192068_c());
            this.addGuiAdvancement(betterAdvancementEntryGui, advancement);
        }
    }

    private void addGuiAdvancement(BetterAdvancementEntryGui betterAdvancementEntryGui, Advancement advancement) {
        this.guis.put(advancement, betterAdvancementEntryGui);
        int left = betterAdvancementEntryGui.getX();
        int right = left + 28;
        int top = betterAdvancementEntryGui.getY();
        int bottom = top + 27;
        this.minX = Math.min(this.minX, left);
        this.maxX = Math.max(this.maxX, right);
        this.minY = Math.min(this.minY, top);
        this.maxY = Math.max(this.maxY, bottom);
        for (BetterAdvancementEntryGui gui : this.guis.values()) {
            gui.attachToParent();
        }
    }

    @Nullable
    public BetterAdvancementEntryGui getAdvancementGui(Advancement advancement) {
        return this.guis.get(advancement);
    }

    public BetterAdvancementsScreen getScreen() {
        return this.screen;
    }

    public BetterDisplayInfo getBetterDisplayInfo(Advancement advancement) {
        return this.betterDisplayInfos.get(advancement);
    }
}

