/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.master;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.data.DimPos;
import com.lothrazar.storagenetwork.block.BaseBlock;
import com.lothrazar.storagenetwork.block.master.TileMaster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockMaster
extends BaseBlock {
    public BlockMaster() {
        super(Material.field_151573_f, "master");
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        this.updateConnection(worldIn, pos, state);
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity tileAtPos = worldIn.func_175625_s(pos);
        if (tileAtPos != null) {
            ((TileMaster)tileAtPos).refreshNetwork();
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult result) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileHere = worldIn.func_175625_s(pos);
        if (!(tileHere instanceof TileMaster)) {
            return ActionResultType.PASS;
        }
        TileMaster tileMaster = (TileMaster)tileHere;
        playerIn.func_145747_a((ITextComponent)new TranslationTextComponent(TextFormatting.LIGHT_PURPLE + StorageNetwork.lang("chat.master.emptyslots") + tileMaster.emptySlots(), new Object[0]));
        playerIn.func_145747_a((ITextComponent)new TranslationTextComponent(TextFormatting.DARK_AQUA + StorageNetwork.lang("chat.master.connectables") + tileMaster.getConnectablePositions().size(), new Object[0]));
        HashMap<String, Integer> mapNamesToCount = new HashMap<String, Integer>();
        for (DimPos p : tileMaster.getConnectablePositions()) {
            String block;
            mapNamesToCount.put(block, mapNamesToCount.get(block = p.getBlockState().func_177230_c().getRegistryName().toString()) != null ? (Integer)mapNamesToCount.get(block) + 1 : 1);
        }
        ArrayList listDisplayStrings = Lists.newArrayList();
        for (Map.Entry e : mapNamesToCount.entrySet()) {
            listDisplayStrings.add(e);
        }
        Collections.sort(listDisplayStrings, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return Integer.compare(o2.getValue(), o1.getValue());
            }
        });
        for (Map.Entry e : listDisplayStrings) {
            playerIn.func_145747_a((ITextComponent)new TranslationTextComponent(TextFormatting.AQUA + "    " + (String)e.getKey() + ": " + e.getValue(), new Object[0]));
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileMaster();
    }
}

