/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.end;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.EndPortalTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Unit;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.EndDimension;
import net.minecraft.world.end.DragonSpawnState;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndGatewayConfig;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import net.minecraft.world.gen.feature.EndSpikeFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonFightManager {
    private static final Logger field_186107_a = LogManager.getLogger();
    private static final Predicate<Entity> field_186108_b = EntityPredicates.field_94557_a.and(EntityPredicates.func_188443_a((double)0.0, (double)128.0, (double)0.0, (double)192.0));
    private final ServerBossInfo field_186109_c = (ServerBossInfo)new ServerBossInfo((ITextComponent)new TranslationTextComponent("entity.minecraft.ender_dragon", new Object[0]), BossInfo.Color.PINK, BossInfo.Overlay.PROGRESS).func_186742_b(true).func_186743_c(true);
    private final ServerWorld field_186110_d;
    private final List<Integer> field_186111_e = Lists.newArrayList();
    private final BlockPattern field_186112_f;
    private int field_186113_g;
    private int field_186114_h;
    private int field_186115_i;
    private int field_186116_j;
    private boolean field_186117_k;
    private boolean field_186118_l;
    private UUID field_186119_m;
    private boolean field_186120_n = true;
    private BlockPos field_186121_o;
    private DragonSpawnState field_186122_p;
    private int field_186123_q;
    private List<EnderCrystalEntity> field_186124_r;

    public DragonFightManager(ServerWorld worldIn, CompoundNBT compound, EndDimension dim) {
        this.field_186110_d = worldIn;
        if (compound.func_150297_b("DragonKilled", 99)) {
            if (compound.func_186855_b("DragonUUID")) {
                this.field_186119_m = compound.func_186857_a("DragonUUID");
            }
            this.field_186117_k = compound.func_74767_n("DragonKilled");
            this.field_186118_l = compound.func_74767_n("PreviouslyKilled");
            boolean bl = this.field_186120_n = !compound.func_74767_n("LegacyScanPerformed");
            if (compound.func_74767_n("IsRespawning")) {
                this.field_186122_p = DragonSpawnState.START;
            }
            if (compound.func_150297_b("ExitPortalLocation", 10)) {
                this.field_186121_o = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("ExitPortalLocation"));
            }
        } else {
            this.field_186117_k = true;
            this.field_186118_l = true;
        }
        if (compound.func_150297_b("Gateways", 9)) {
            ListNBT listnbt = compound.func_150295_c("Gateways", 3);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.field_186111_e.add(listnbt.func_186858_c(i));
            }
        } else {
            this.field_186111_e.addAll((Collection<Integer>)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            Collections.shuffle(this.field_186111_e, new Random(dim.getSeed()));
        }
        this.field_186112_f = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  "}).func_177659_a(new String[]{"       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       "}).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150357_h))).func_177661_b();
    }

    public CompoundNBT func_186088_a() {
        CompoundNBT compoundnbt = new CompoundNBT();
        if (this.field_186119_m != null) {
            compoundnbt.func_186854_a("DragonUUID", this.field_186119_m);
        }
        compoundnbt.func_74757_a("DragonKilled", this.field_186117_k);
        compoundnbt.func_74757_a("PreviouslyKilled", this.field_186118_l);
        compoundnbt.func_74757_a("LegacyScanPerformed", !this.field_186120_n);
        if (this.field_186121_o != null) {
            compoundnbt.func_218657_a("ExitPortalLocation", NBTUtil.func_186859_a((BlockPos)this.field_186121_o));
        }
        ListNBT listnbt = new ListNBT();
        for (int i : this.field_186111_e) {
            listnbt.add((Object)IntNBT.func_229692_a_((int)i));
        }
        compoundnbt.func_218657_a("Gateways", (INBT)listnbt);
        return compoundnbt;
    }

    public void func_186105_b() {
        this.field_186109_c.func_186758_d(!this.field_186117_k);
        if (++this.field_186116_j >= 20) {
            this.func_186100_j();
            this.field_186116_j = 0;
        }
        if (!this.field_186109_c.func_186757_c().isEmpty()) {
            this.field_186110_d.func_72863_F().func_217228_a(TicketType.field_219489_b, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
            boolean flag = this.func_222670_k();
            if (this.field_186120_n && flag) {
                this.func_210827_g();
                this.field_186120_n = false;
            }
            if (this.field_186122_p != null) {
                if (this.field_186124_r == null && flag) {
                    this.field_186122_p = null;
                    this.func_186106_e();
                }
                this.field_186122_p.func_186079_a(this.field_186110_d, this, this.field_186124_r, this.field_186123_q++, this.field_186121_o);
            }
            if (!this.field_186117_k) {
                if ((this.field_186119_m == null || ++this.field_186113_g >= 1200) && flag) {
                    this.func_210828_h();
                    this.field_186113_g = 0;
                }
                if (++this.field_186115_i >= 100 && flag) {
                    this.func_186101_k();
                    this.field_186115_i = 0;
                }
            }
        } else {
            this.field_186110_d.func_72863_F().func_217222_b(TicketType.field_219489_b, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
        }
    }

    private void func_210827_g() {
        field_186107_a.info("Scanning for legacy world dragon fight...");
        boolean flag = this.func_229981_i_();
        if (flag) {
            field_186107_a.info("Found that the dragon has been killed in this world already.");
            this.field_186118_l = true;
        } else {
            field_186107_a.info("Found that the dragon has not yet been killed in this world.");
            this.field_186118_l = false;
            if (this.func_186091_h() == null) {
                this.func_186094_a(false);
            }
        }
        List<EnderDragonEntity> list = this.field_186110_d.func_217439_j();
        if (list.isEmpty()) {
            this.field_186117_k = true;
        } else {
            EnderDragonEntity enderdragonentity = list.get(0);
            this.field_186119_m = enderdragonentity.func_110124_au();
            field_186107_a.info("Found that there's a dragon still alive ({})", (Object)enderdragonentity);
            this.field_186117_k = false;
            if (!flag) {
                field_186107_a.info("But we didn't have a portal, let's remove it.");
                enderdragonentity.func_70106_y();
                this.field_186119_m = null;
            }
        }
        if (!this.field_186118_l && this.field_186117_k) {
            this.field_186117_k = false;
        }
    }

    private void func_210828_h() {
        List<EnderDragonEntity> list = this.field_186110_d.func_217439_j();
        if (list.isEmpty()) {
            field_186107_a.debug("Haven't seen the dragon, respawning it");
            this.func_192445_m();
        } else {
            field_186107_a.debug("Haven't seen our dragon, but found another one to use.");
            this.field_186119_m = list.get(0).func_110124_au();
        }
    }

    protected void func_186095_a(DragonSpawnState state) {
        if (this.field_186122_p == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.field_186123_q = 0;
        if (state == DragonSpawnState.END) {
            this.field_186122_p = null;
            this.field_186117_k = false;
            EnderDragonEntity enderdragonentity = this.func_192445_m();
            for (ServerPlayerEntity serverplayerentity : this.field_186109_c.func_186757_c()) {
                CriteriaTriggers.field_192133_m.func_192229_a(serverplayerentity, (Entity)enderdragonentity);
            }
        } else {
            this.field_186122_p = state;
        }
    }

    private boolean func_229981_i_() {
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                Chunk chunk = this.field_186110_d.func_212866_a_(i, j);
                for (TileEntity tileentity : chunk.func_177434_r().values()) {
                    if (!(tileentity instanceof EndPortalTileEntity)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private BlockPattern.PatternHelper func_186091_h() {
        int k;
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                Chunk chunk = this.field_186110_d.func_212866_a_(i, j);
                for (TileEntity tileentity : chunk.func_177434_r().values()) {
                    BlockPattern.PatternHelper blockpattern$patternhelper;
                    if (!(tileentity instanceof EndPortalTileEntity) || (blockpattern$patternhelper = this.field_186112_f.func_177681_a((IWorldReader)this.field_186110_d, tileentity.func_174877_v())) == null) continue;
                    BlockPos blockpos = blockpattern$patternhelper.func_177670_a(3, 3, 3).func_177508_d();
                    if (this.field_186121_o == null && blockpos.func_177958_n() == 0 && blockpos.func_177952_p() == 0) {
                        this.field_186121_o = blockpos;
                    }
                    return blockpattern$patternhelper;
                }
            }
        }
        for (int l = k = this.field_186110_d.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EndPodiumFeature.field_186139_a).func_177956_o(); l >= 0; --l) {
            BlockPattern.PatternHelper blockpattern$patternhelper1 = this.field_186112_f.func_177681_a((IWorldReader)this.field_186110_d, new BlockPos(EndPodiumFeature.field_186139_a.func_177958_n(), l, EndPodiumFeature.field_186139_a.func_177952_p()));
            if (blockpattern$patternhelper1 == null) continue;
            if (this.field_186121_o == null) {
                this.field_186121_o = blockpattern$patternhelper1.func_177670_a(3, 3, 3).func_177508_d();
            }
            return blockpattern$patternhelper1;
        }
        return null;
    }

    private boolean func_222670_k() {
        for (int i = -8; i <= 8; ++i) {
            for (int j = 8; j <= 8; ++j) {
                IChunk ichunk = this.field_186110_d.func_217353_a(i, j, ChunkStatus.field_222617_m, false);
                if (!(ichunk instanceof Chunk)) {
                    return false;
                }
                ChunkHolder.LocationType chunkholder$locationtype = ((Chunk)ichunk).func_217321_u();
                if (chunkholder$locationtype.func_219065_a(ChunkHolder.LocationType.TICKING)) continue;
                return false;
            }
        }
        return true;
    }

    private void func_186100_j() {
        HashSet set = Sets.newHashSet();
        for (ServerPlayerEntity serverplayerentity : this.field_186110_d.func_217490_a(field_186108_b)) {
            this.field_186109_c.func_186760_a(serverplayerentity);
            set.add(serverplayerentity);
        }
        HashSet set1 = Sets.newHashSet((Iterable)this.field_186109_c.func_186757_c());
        set1.removeAll(set);
        for (ServerPlayerEntity serverplayerentity1 : set1) {
            this.field_186109_c.func_186761_b(serverplayerentity1);
        }
    }

    private void func_186101_k() {
        this.field_186115_i = 0;
        this.field_186114_h = 0;
        for (EndSpikeFeature.EndSpike endspikefeature$endspike : EndSpikeFeature.func_214554_a((IWorld)this.field_186110_d)) {
            this.field_186114_h += this.field_186110_d.func_217357_a(EnderCrystalEntity.class, endspikefeature$endspike.func_186153_f()).size();
        }
        field_186107_a.debug("Found {} end crystals still alive", (Object)this.field_186114_h);
    }

    public void func_186096_a(EnderDragonEntity dragon) {
        if (dragon.func_110124_au().equals(this.field_186119_m)) {
            this.field_186109_c.func_186735_a(0.0f);
            this.field_186109_c.func_186758_d(false);
            this.func_186094_a(true);
            this.func_186097_l();
            if (!this.field_186118_l) {
                this.field_186110_d.func_175656_a(this.field_186110_d.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EndPodiumFeature.field_186139_a), Blocks.field_150380_bt.func_176223_P());
            }
            this.field_186118_l = true;
            this.field_186117_k = true;
        }
    }

    private void func_186097_l() {
        if (!this.field_186111_e.isEmpty()) {
            int i = this.field_186111_e.remove(this.field_186111_e.size() - 1);
            int j = MathHelper.func_76128_c((double)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
            int k = MathHelper.func_76128_c((double)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
            this.func_186089_a(new BlockPos(j, 75, k));
        }
    }

    private void func_186089_a(BlockPos pos) {
        this.field_186110_d.func_217379_c(3000, pos, 0);
        Feature.field_202299_as.func_225566_b_(EndGatewayConfig.func_214698_a()).func_222734_a((IWorld)this.field_186110_d, this.field_186110_d.func_72863_F().func_201711_g(), new Random(), pos);
    }

    private void func_186094_a(boolean active) {
        EndPodiumFeature endpodiumfeature = new EndPodiumFeature(active);
        if (this.field_186121_o == null) {
            this.field_186121_o = this.field_186110_d.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a).func_177977_b();
            while (this.field_186110_d.func_180495_p(this.field_186121_o).func_177230_c() == Blocks.field_150357_h && this.field_186121_o.func_177956_o() > this.field_186110_d.func_181545_F()) {
                this.field_186121_o = this.field_186121_o.func_177977_b();
            }
        }
        endpodiumfeature.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_222734_a((IWorld)this.field_186110_d, this.field_186110_d.func_72863_F().func_201711_g(), new Random(), this.field_186121_o);
    }

    private EnderDragonEntity func_192445_m() {
        this.field_186110_d.func_175726_f(new BlockPos(0, 128, 0));
        EnderDragonEntity enderdragonentity = EntityType.field_200802_p.func_200721_a(this.field_186110_d);
        enderdragonentity.func_184670_cT().func_188758_a(PhaseType.field_188741_a);
        enderdragonentity.func_70012_b(0.0, 128.0, 0.0, this.field_186110_d.field_73012_v.nextFloat() * 360.0f, 0.0f);
        this.field_186110_d.func_217376_c(enderdragonentity);
        this.field_186119_m = enderdragonentity.func_110124_au();
        return enderdragonentity;
    }

    public void func_186099_b(EnderDragonEntity dragonIn) {
        if (dragonIn.func_110124_au().equals(this.field_186119_m)) {
            this.field_186109_c.func_186735_a(dragonIn.func_110143_aJ() / dragonIn.func_110138_aP());
            this.field_186113_g = 0;
            if (dragonIn.func_145818_k_()) {
                this.field_186109_c.func_186739_a(dragonIn.func_145748_c_());
            }
        }
    }

    public int func_186092_c() {
        return this.field_186114_h;
    }

    public void func_186090_a(EnderCrystalEntity crystal, DamageSource dmgSrc) {
        if (this.field_186122_p != null && this.field_186124_r.contains(crystal)) {
            field_186107_a.debug("Aborting respawn sequence");
            this.field_186122_p = null;
            this.field_186123_q = 0;
            this.func_186087_f();
            this.func_186094_a(true);
        } else {
            this.func_186101_k();
            Entity entity = this.field_186110_d.func_217461_a(this.field_186119_m);
            if (entity instanceof EnderDragonEntity) {
                ((EnderDragonEntity)entity).func_184672_a(crystal, new BlockPos((Entity)crystal), dmgSrc);
            }
        }
    }

    public boolean func_186102_d() {
        return this.field_186118_l;
    }

    public void func_186106_e() {
        if (this.field_186117_k && this.field_186122_p == null) {
            BlockPos blockpos = this.field_186121_o;
            if (blockpos == null) {
                field_186107_a.debug("Tried to respawn, but need to find the portal first.");
                BlockPattern.PatternHelper blockpattern$patternhelper = this.func_186091_h();
                if (blockpattern$patternhelper == null) {
                    field_186107_a.debug("Couldn't find a portal, so we made one.");
                    this.func_186094_a(true);
                } else {
                    field_186107_a.debug("Found the exit portal & temporarily using it.");
                }
                blockpos = this.field_186121_o;
            }
            ArrayList list1 = Lists.newArrayList();
            BlockPos blockpos1 = blockpos.func_177981_b(1);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                List list = this.field_186110_d.func_217357_a(EnderCrystalEntity.class, new AxisAlignedBB(blockpos1.func_177967_a(direction, 2)));
                if (list.isEmpty()) {
                    return;
                }
                list1.addAll(list);
            }
            field_186107_a.debug("Found all crystals, respawning dragon.");
            this.func_186093_a(list1);
        }
    }

    private void func_186093_a(List<EnderCrystalEntity> crystalsIn) {
        if (this.field_186117_k && this.field_186122_p == null) {
            BlockPattern.PatternHelper blockpattern$patternhelper = this.func_186091_h();
            while (blockpattern$patternhelper != null) {
                for (int i = 0; i < this.field_186112_f.func_177684_c(); ++i) {
                    for (int j = 0; j < this.field_186112_f.func_177685_b(); ++j) {
                        for (int k = 0; k < this.field_186112_f.func_185922_a(); ++k) {
                            CachedBlockInfo cachedblockinfo = blockpattern$patternhelper.func_177670_a(i, j, k);
                            if (cachedblockinfo.func_177509_a().func_177230_c() != Blocks.field_150357_h && cachedblockinfo.func_177509_a().func_177230_c() != Blocks.field_150384_bq) continue;
                            this.field_186110_d.func_175656_a(cachedblockinfo.func_177508_d(), Blocks.field_150377_bs.func_176223_P());
                        }
                    }
                }
                blockpattern$patternhelper = this.func_186091_h();
            }
            this.field_186122_p = DragonSpawnState.START;
            this.field_186123_q = 0;
            this.func_186094_a(false);
            this.field_186124_r = crystalsIn;
        }
    }

    public void func_186087_f() {
        for (EndSpikeFeature.EndSpike endspikefeature$endspike : EndSpikeFeature.func_214554_a((IWorld)this.field_186110_d)) {
            for (EnderCrystalEntity endercrystalentity : this.field_186110_d.func_217357_a(EnderCrystalEntity.class, endspikefeature$endspike.func_186153_f())) {
                endercrystalentity.func_184224_h(false);
                endercrystalentity.func_184516_a((BlockPos)null);
            }
        }
    }

    public void addPlayer(ServerPlayerEntity player) {
        this.field_186109_c.func_186760_a(player);
    }

    public void removePlayer(ServerPlayerEntity player) {
        this.field_186109_c.func_186761_b(player);
    }
}

