/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.DefendVillageTargetGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.MoveTowardsVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ShowVillagerFlowerGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IronGolemEntity
extends GolemEntity {
    protected static final DataParameter<Byte> field_184750_a = EntityDataManager.func_187226_a(IronGolemEntity.class, DataSerializers.field_187191_a);
    private int field_70855_f;
    private int field_70856_g;

    public IronGolemEntity(EntityType<? extends IronGolemEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveTowardsVillageGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(3, (Goal)new MoveThroughVillageGoal((CreatureEntity)this, 0.6, false, 4, () -> false));
        this.field_70714_bg.func_75776_a(5, (Goal)new ShowVillagerFlowerGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)((Object)this)));
        this.field_70715_bh.func_75776_a(1, (Goal)new DefendVillageTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), MobEntity.class, 5, false, false, p_213619_0_ -> p_213619_0_ instanceof IMob && !(p_213619_0_ instanceof CreeperEntity)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184750_a, (byte)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(15.0);
    }

    protected int func_70682_h(int air) {
        return air;
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof IMob && !(entityIn instanceof CreeperEntity) && this.func_70681_au().nextInt(20) == 0) {
            this.func_70624_b((LivingEntity)entityIn);
        }
        super.func_82167_n(entityIn);
    }

    public void func_70636_d() {
        int k;
        int j;
        int i;
        BlockPos pos;
        BlockState blockstate;
        super.func_70636_d();
        if (this.field_70855_f > 0) {
            --this.field_70855_f;
        }
        if (this.field_70856_g > 0) {
            --this.field_70856_g;
        }
        if (IronGolemEntity.func_213296_b((Vec3d)this.func_213322_ci()) > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && !(blockstate = this.field_70170_p.func_180495_p(pos = new BlockPos(i = MathHelper.func_76128_c((double)this.func_226277_ct_()), j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f)), k = MathHelper.func_76128_c((double)this.func_226281_cx_())))).isAir((IBlockReader)((Object)this.field_70170_p), pos)) {
            this.field_70170_p.func_195594_a(new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(pos), this.func_226277_ct_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + 0.1, this.func_226281_cx_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
        }
    }

    public boolean func_213358_a(EntityType<?> typeIn) {
        if (this.func_70850_q() && typeIn == EntityType.field_200729_aH) {
            return false;
        }
        return typeIn == EntityType.field_200797_k ? false : super.func_213358_a(typeIn);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("PlayerCreated", this.func_70850_q());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_70849_f(compound.func_74767_n("PlayerCreated"));
    }

    private float func_226511_et_() {
        return (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
    }

    public boolean func_70652_k(Entity entityIn) {
        this.field_70855_f = 10;
        this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)4);
        float f = this.func_226511_et_();
        float f1 = f > 0.0f ? f / 2.0f + (float)this.field_70146_Z.nextInt((int)f) : 0.0f;
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)((Object)this)), f1);
        if (flag) {
            entityIn.func_213317_d(entityIn.func_213322_ci().func_72441_c(0.0, 0.4f, 0.0));
            this.func_174815_a((LivingEntity)((Object)this), entityIn);
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Cracks irongolementity$cracks = this.func_226512_l_();
        boolean flag = super.func_70097_a(source, amount);
        if (flag && this.func_226512_l_() != irongolementity$cracks) {
            this.func_184185_a(SoundEvents.field_226142_fM_, 1.0f, 1.0f);
        }
        return flag;
    }

    public Cracks func_226512_l_() {
        return Cracks.func_226515_a_(this.func_110143_aJ() / this.func_110138_aP());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.field_70855_f = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else if (id == 11) {
            this.field_70856_g = 400;
        } else if (id == 34) {
            this.field_70856_g = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70854_o() {
        return this.field_70855_f;
    }

    public void func_70851_e(boolean holdingRose) {
        if (holdingRose) {
            this.field_70856_g = 400;
            this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)11);
        } else {
            this.field_70856_g = 0;
            this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)34);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (item != Items.field_151042_j) {
            return false;
        }
        float f = this.func_110143_aJ();
        this.func_70691_i(25.0f);
        if (this.func_110143_aJ() == f) {
            return false;
        }
        float f1 = 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
        this.func_184185_a(SoundEvents.field_226143_fP_, 1.0f, f1);
        if (!player.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        return true;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70853_p() {
        return this.field_70856_g;
    }

    public boolean func_70850_q() {
        return (this.field_70180_af.func_187225_a(field_184750_a) & 1) != 0;
    }

    public void func_70849_f(boolean playerCreated) {
        byte b0 = this.field_70180_af.func_187225_a(field_184750_a);
        if (playerCreated) {
            this.field_70180_af.func_187227_b(field_184750_a, (byte)(b0 | 1));
        } else {
            this.field_70180_af.func_187227_b(field_184750_a, (byte)(b0 & 0xFFFFFFFE));
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        BlockPos blockpos = new BlockPos((Entity)((Object)this));
        BlockPos blockpos1 = blockpos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos1);
        if (!blockstate.func_215682_a((IBlockReader)((Object)worldIn), blockpos1, (Entity)((Object)this))) {
            return false;
        }
        for (int i = 1; i < 3; ++i) {
            BlockState blockstate1;
            BlockPos blockpos2 = blockpos.func_177981_b(i);
            if (WorldEntitySpawner.func_222266_a((IBlockReader)((Object)worldIn), blockpos2, blockstate1 = worldIn.func_180495_p(blockpos2), blockstate1.func_204520_s())) continue;
            return false;
        }
        return WorldEntitySpawner.func_222266_a((IBlockReader)((Object)worldIn), blockpos, worldIn.func_180495_p(blockpos), Fluids.field_204541_a.func_207188_f()) && worldIn.func_226668_i_((Entity)((Object)this));
    }

    public static enum Cracks {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Cracks> field_226513_e_;
        private final float field_226514_f_;

        private Cracks(float p_i225732_3_) {
            this.field_226514_f_ = p_i225732_3_;
        }

        public static Cracks func_226515_a_(float p_226515_0_) {
            for (Cracks irongolementity$cracks : field_226513_e_) {
                if (!(p_226515_0_ < irongolementity$cracks.field_226514_f_)) continue;
                return irongolementity$cracks;
            }
            return NONE;
        }

        static {
            field_226513_e_ = (List)Stream.of(Cracks.values()).sorted(Comparator.comparingDouble(p_226516_0_ -> p_226516_0_.field_226514_f_)).collect(ImmutableList.toImmutableList());
        }
    }
}

