/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.common.biome.BiomeBOP;
import biomesoplenty.common.world.BOPLayerUtil;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.layer.traits.IAreaTransformer2;
import net.minecraft.world.gen.layer.traits.IDimOffset0Transformer;

public enum BOPRiverMixLayer implements IAreaTransformer2,
IDimOffset0Transformer
{
    INSTANCE;

    private static final int FROZEN_RIVER;
    private static final int SNOWY_TUNDRA;
    private static final int MUSHROOM_FIELDS;
    private static final int MUSHROOM_FIELD_SHORE;
    private static final int RIVER;

    public int func_215723_a(INoiseRandom context, IArea biomeArea, IArea riverArea, int x, int z) {
        int biomeId = biomeArea.func_202678_a(x, z);
        int riverId = riverArea.func_202678_a(x, z);
        Biome biome = (Biome)Registry.field_212624_m.func_148745_a(biomeId);
        if (BOPLayerUtil.isOcean(biomeId)) {
            return biomeId;
        }
        if (riverId == RIVER) {
            if (biomeId == SNOWY_TUNDRA) {
                return FROZEN_RIVER;
            }
            if (biome instanceof BiomeBOP) {
                BiomeBOP biomeBOP = (BiomeBOP)biome;
                if (biomeBOP.riverBiomeId != -1) {
                    return biomeBOP.riverBiomeId;
                }
                return biomeId;
            }
            return biomeId != MUSHROOM_FIELDS && biomeId != MUSHROOM_FIELD_SHORE ? riverId & 0xFF : MUSHROOM_FIELD_SHORE;
        }
        return biomeId;
    }

    static {
        FROZEN_RIVER = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76777_m);
        SNOWY_TUNDRA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76774_n);
        MUSHROOM_FIELDS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76789_p);
        MUSHROOM_FIELD_SHORE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76788_q);
        RIVER = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76781_i);
    }
}

