/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.tools.common.IHasRepairType;
import mekanism.tools.common.ToolsLang;
import mekanism.tools.common.material.BaseMekanismMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.ToolItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class ItemMekanismPaxel
extends ToolItem
implements IHasRepairType {
    private static final ToolType PAXEL_TOOL_TYPE = ToolType.get((String)"paxel");
    private final FloatSupplier paxelDamage;
    private final FloatSupplier paxelAtkSpeed;
    private final FloatSupplier paxelEfficiency;
    private final IntSupplier paxelEnchantability;
    private final IntSupplier paxelMaxDurability;
    private final IntSupplier paxelHarvestLevel;

    private static Item.Properties getItemProperties(int harvestLevel) {
        return ItemDeferredRegister.getMekBaseProperties().addToolType(ToolType.AXE, harvestLevel).addToolType(ToolType.PICKAXE, harvestLevel).addToolType(ToolType.SHOVEL, harvestLevel).addToolType(PAXEL_TOOL_TYPE, harvestLevel);
    }

    public ItemMekanismPaxel(BaseMekanismMaterial material) {
        super(material.getPaxelDamage(), material.getPaxelAtkSpeed(), (IItemTier)material, Collections.emptySet(), ItemMekanismPaxel.getItemProperties(material.getPaxelHarvestLevel()));
        this.paxelDamage = material::getPaxelDamage;
        this.paxelAtkSpeed = material::getPaxelAtkSpeed;
        this.paxelEfficiency = material::getPaxelEfficiency;
        this.paxelEnchantability = material::getPaxelEnchantability;
        this.paxelMaxDurability = material::getPaxelMaxUses;
        this.paxelHarvestLevel = material::getPaxelHarvestLevel;
    }

    public ItemMekanismPaxel(ItemTier material) {
        super(4.0f, -2.4f, (IItemTier)material, Collections.emptySet(), ItemMekanismPaxel.getItemProperties(material.func_200925_d()));
        this.paxelDamage = () -> 4.0f;
        this.paxelAtkSpeed = () -> -2.4f;
        this.paxelEfficiency = () -> ((ItemTier)material).func_200928_b();
        this.paxelEnchantability = () -> ((ItemTier)material).func_200927_e();
        this.paxelMaxDurability = () -> ((ItemTier)material).func_200926_a();
        this.paxelHarvestLevel = () -> ((ItemTier)material).func_200925_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)ToolsLang.HP.translate(new Object[]{stack.func_77958_k() - stack.func_77952_i()}));
    }

    private float getAttackDamage() {
        return this.paxelDamage.getAsFloat() + this.func_200891_e().func_200929_c();
    }

    private int getHarvestLevel() {
        return this.paxelHarvestLevel.getAsInt();
    }

    public boolean func_150897_b(BlockState state) {
        ToolType harvestTool = state.getHarvestTool();
        if ((harvestTool == ToolType.AXE || harvestTool == ToolType.PICKAXE || harvestTool == ToolType.SHOVEL) && this.getHarvestLevel() >= state.getHarvestLevel()) {
            return true;
        }
        Block block = state.func_177230_c();
        if (block == Blocks.field_150433_aE || block == Blocks.field_196604_cC) {
            return true;
        }
        Material material = state.func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g;
    }

    public float func_150893_a(@Nonnull ItemStack stack, BlockState state) {
        block3: {
            block2: {
                boolean axeShortcut;
                Material material = state.func_185904_a();
                boolean pickaxeShortcut = material == Material.field_151573_f || material == Material.field_151574_g || material == Material.field_151576_e;
                boolean bl = axeShortcut = material == Material.field_151575_d || material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_215713_z;
                if (pickaxeShortcut || axeShortcut) break block2;
                if (!this.getToolTypes(stack).stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0)) && !this.field_150914_c.contains(state.func_177230_c())) break block3;
            }
            return this.paxelEfficiency.getAsFloat();
        }
        return 1.0f;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        BlockState blockstate = world.func_180495_p(blockpos);
        BlockState resultToSet = null;
        Block strippedResult = (Block)AxeItem.field_203176_a.get(blockstate.func_177230_c());
        if (strippedResult != null) {
            world.func_184133_a(player, blockpos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            resultToSet = (BlockState)strippedResult.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, blockstate.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M));
        } else {
            if (context.func_196000_l() == Direction.DOWN) {
                return ActionResultType.PASS;
            }
            BlockState foundResult = (BlockState)ShovelItem.field_195955_e.get(blockstate.func_177230_c());
            if (foundResult != null && world.func_175623_d(blockpos.func_177984_a())) {
                world.func_184133_a(player, blockpos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                resultToSet = foundResult;
            } else if (blockstate.func_177230_c() instanceof CampfireBlock && ((Boolean)blockstate.func_177229_b((IProperty)CampfireBlock.field_220101_b)).booleanValue()) {
                world.func_217378_a(null, 1009, blockpos, 0);
                resultToSet = (BlockState)blockstate.func_206870_a((IProperty)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false));
            }
        }
        if (resultToSet == null) {
            return ActionResultType.PASS;
        }
        if (!world.field_72995_K) {
            world.func_180501_a(blockpos, resultToSet, 11);
            if (player != null) {
                context.func_195996_i().func_222118_a(1, (LivingEntity)player, onBroken -> onBroken.func_213334_d(context.func_221531_n()));
            }
        }
        return ActionResultType.SUCCESS;
    }

    public int func_77619_b() {
        return this.paxelEnchantability.getAsInt();
    }

    @Override
    @Nonnull
    public Ingredient getRepairMaterial() {
        return this.func_200891_e().func_200924_f();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.paxelMaxDurability.getAsInt();
    }

    public boolean func_77645_m() {
        return this.paxelMaxDurability.getAsInt() > 0;
    }

    public int getHarvestLevel(ItemStack stack, @Nonnull ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        if (tool == ToolType.AXE || tool == ToolType.PICKAXE || tool == ToolType.SHOVEL || tool == PAXEL_TOOL_TYPE) {
            return this.getHarvestLevel();
        }
        return super.getHarvestLevel(stack, tool, player, blockState);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(@Nonnull EquipmentSlotType slot) {
        HashMultimap attributes = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            attributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.getAttackDamage(), AttributeModifier.Operation.ADDITION));
            attributes.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.paxelAtkSpeed.getAsFloat(), AttributeModifier.Operation.ADDITION));
        }
        return attributes;
    }

    @FunctionalInterface
    private static interface FloatSupplier {
        public float getAsFloat();
    }
}

