/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemBreakPrevention
extends ItemImpl {
    public ItemBreakPrevention() {
        super("break_prevention");
        MinecraftForge.EVENT_BUS.register((Object)new Events());
    }

    public static class Events {
        @SubscribeEvent
        public void onAnvilUpdate(AnvilUpdateEvent event) {
            ItemStack stack = event.getLeft();
            if (stack.getToolTypes().isEmpty() || !stack.func_77984_f()) {
                return;
            }
            ItemStack second = event.getRight();
            if (second.func_77973_b() != ModItems.BREAK_PREVENTION) {
                return;
            }
            ItemStack output = stack.func_77946_l();
            output.func_196082_o().func_74757_a("naturesaura:break_prevention", true);
            event.setOutput(output);
            event.setMaterialCost(1);
            event.setCost(1);
        }

        @SubscribeEvent
        public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
            PlayerEntity player = event.getPlayer();
            if (player == null) {
                return;
            }
            ItemStack stack = player.func_184614_ca();
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("naturesaura:break_prevention")) {
                return;
            }
            if (ElytraItem.func_185069_d((ItemStack)stack)) {
                return;
            }
            event.setNewSpeed(0.0f);
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void onTooltip(ItemTooltipEvent event) {
            ItemStack stack = event.getItemStack();
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("naturesaura:break_prevention")) {
                return;
            }
            List tooltip = event.getToolTip();
            tooltip.add(new TranslationTextComponent("info.naturesaura.break_prevention", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
            if (ElytraItem.func_185069_d((ItemStack)stack)) {
                return;
            }
            if (tooltip.size() < 1) {
                return;
            }
            ((ITextComponent)tooltip.get(0)).func_150257_a(new TranslationTextComponent("info.naturesaura.broken", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
    }
}

