/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.packet.PacketAuraChunk;
import de.ellpeck.naturesaura.packet.PacketHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.mutable.MutableInt;

public class AuraChunk
implements IAuraChunk {
    private final Chunk chunk;
    private final IAuraType type;
    private final Map<BlockPos, MutableInt> drainSpots = new ConcurrentHashMap<BlockPos, MutableInt>();
    private final List<IDrainSpotEffect> effects = new ArrayList<IDrainSpotEffect>();
    private boolean needsSync;

    public AuraChunk(Chunk chunk, IAuraType type) {
        this.chunk = chunk;
        this.type = type;
        for (Supplier<IDrainSpotEffect> supplier : NaturesAuraAPI.DRAIN_SPOT_EFFECTS.values()) {
            IDrainSpotEffect effect = supplier.get();
            if (!effect.appliesHere(this.chunk, this, this.type)) continue;
            this.effects.add(effect);
        }
    }

    @Override
    public int drainAura(BlockPos pos, int amount, boolean aimForZero, boolean simulate) {
        if (amount <= 0) {
            return 0;
        }
        MutableInt spot = this.getActualDrainSpot(pos, true);
        int curr = spot.intValue();
        if (curr < 0 && curr - amount > 0) {
            return this.drainAura(pos.func_177984_a(), amount, aimForZero, simulate);
        }
        if (aimForZero && curr > 0 && curr - amount < 0) {
            amount = curr;
        }
        if (!simulate) {
            spot.subtract(amount);
            if (spot.intValue() == 0) {
                this.drainSpots.remove(pos);
            }
            this.markDirty();
        }
        return amount;
    }

    @Override
    public int drainAura(BlockPos pos, int amount) {
        return this.drainAura(pos, amount, false, false);
    }

    @Override
    public int storeAura(BlockPos pos, int amount, boolean aimForZero, boolean simulate) {
        if (amount <= 0) {
            return 0;
        }
        MutableInt spot = this.getActualDrainSpot(pos, true);
        int curr = spot.intValue();
        if (curr > 0 && curr + amount < 0) {
            return this.storeAura(pos.func_177984_a(), amount, aimForZero, simulate);
        }
        if (aimForZero && curr < 0 && curr + amount > 0) {
            amount = -curr;
        }
        if (!simulate) {
            spot.add(amount);
            if (spot.intValue() == 0) {
                this.drainSpots.remove(pos);
            }
            this.markDirty();
        }
        return amount;
    }

    @Override
    public int storeAura(BlockPos pos, int amount) {
        return this.storeAura(pos, amount, true, false);
    }

    private MutableInt getActualDrainSpot(BlockPos pos, boolean make) {
        MutableInt spot = this.drainSpots.get(pos);
        if (spot == null && make) {
            spot = new MutableInt();
            this.addDrainSpot(pos, spot);
        }
        return spot;
    }

    @Override
    public int getDrainSpot(BlockPos pos) {
        MutableInt spot = this.getActualDrainSpot(pos, false);
        return spot == null ? 0 : spot.intValue();
    }

    private void addDrainSpot(BlockPos pos, MutableInt spot) {
        int expX = pos.func_177958_n() >> 4;
        int expZ = pos.func_177952_p() >> 4;
        ChunkPos myPos = this.chunk.func_76632_l();
        if (expX != myPos.field_77276_a || expZ != myPos.field_77275_b) {
            throw new IllegalArgumentException("Tried to add drain spot " + pos + " to chunk at " + myPos.field_77276_a + ", " + myPos.field_77275_b + " when it should've been added to chunk at " + expX + ", " + expZ);
        }
        this.drainSpots.put(pos, spot);
    }

    public void setSpots(Map<BlockPos, MutableInt> spots) {
        this.drainSpots.clear();
        for (Map.Entry<BlockPos, MutableInt> entry : spots.entrySet()) {
            this.addDrainSpot(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public IAuraType getType() {
        return this.type;
    }

    @Override
    public void markDirty() {
        this.chunk.func_76630_e();
        this.needsSync = true;
    }

    public void update() {
        World world = this.chunk.func_177412_p();
        for (Map.Entry<BlockPos, MutableInt> entry : this.drainSpots.entrySet()) {
            BlockPos pos = entry.getKey();
            MutableInt amount = entry.getValue();
            for (IDrainSpotEffect effect : this.effects) {
                effect.update(world, this.chunk, this, pos, amount.intValue());
            }
        }
        if (this.needsSync) {
            ChunkPos pos = this.chunk.func_76632_l();
            PacketHandler.sendToAllLoaded(world, new BlockPos(pos.field_77276_a * 16, 0, pos.field_77275_b * 16), this.makePacket());
            this.needsSync = false;
        }
    }

    public PacketAuraChunk makePacket() {
        ChunkPos pos = this.chunk.func_76632_l();
        return new PacketAuraChunk(pos.field_77276_a, pos.field_77275_b, this.drainSpots);
    }

    public void getSpotsInArea(BlockPos pos, int radius, BiConsumer<BlockPos, Integer> consumer) {
        for (Map.Entry<BlockPos, MutableInt> entry : this.drainSpots.entrySet()) {
            BlockPos drainPos = entry.getKey();
            if (!(drainPos.func_177951_i((Vec3i)pos) <= (double)(radius * radius))) continue;
            consumer.accept(drainPos, entry.getValue().intValue());
        }
    }

    public void getActiveEffectIcons(PlayerEntity player, Map<ResourceLocation, Tuple<ItemStack, Boolean>> icons) {
        for (IDrainSpotEffect effect : this.effects) {
            Tuple<ItemStack, Boolean> alreadyThere = icons.get(effect.getName());
            if (alreadyThere != null && ((Boolean)alreadyThere.func_76340_b()).booleanValue()) continue;
            for (Map.Entry<BlockPos, MutableInt> entry : this.drainSpots.entrySet()) {
                ItemStack stack;
                MutableInt amount;
                BlockPos pos = entry.getKey();
                IDrainSpotEffect.ActiveType state = effect.isActiveHere(player, this.chunk, this, pos, (amount = entry.getValue()).intValue());
                if (state == IDrainSpotEffect.ActiveType.INACTIVE || (stack = effect.getDisplayIcon()).func_190926_b()) continue;
                icons.put(effect.getName(), (Tuple<ItemStack, Boolean>)new Tuple((Object)stack, (Object)(state == IDrainSpotEffect.ActiveType.INHIBITED ? 1 : 0)));
            }
        }
    }

    public CompoundNBT serializeNBT() {
        ListNBT list = new ListNBT();
        for (Map.Entry<BlockPos, MutableInt> entry : this.drainSpots.entrySet()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74772_a("pos", entry.getKey().func_218275_a());
            tag.func_74768_a("amount", entry.getValue().intValue());
            list.add((Object)tag);
        }
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("drain_spots", (INBT)list);
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        this.drainSpots.clear();
        ListNBT list = compound.func_150295_c("drain_spots", 10);
        for (INBT base : list) {
            CompoundNBT tag = (CompoundNBT)base;
            this.addDrainSpot(BlockPos.func_218283_e((long)tag.func_74763_f("pos")), new MutableInt(tag.func_74762_e("amount")));
        }
    }
}

