/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic;

import java.util.Objects;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ModuleTarget {
    public final GlobalPos gPos;
    public final Direction face;
    public final String blockTranslationKey;

    public ModuleTarget(GlobalPos gPos, Direction face, String blockTranslationKey) {
        this.gPos = gPos;
        this.face = face;
        this.blockTranslationKey = blockTranslationKey;
    }

    public ModuleTarget(GlobalPos gPos, Direction face) {
        this(gPos, face, "");
    }

    public ModuleTarget(GlobalPos gPos) {
        this(gPos, null);
    }

    public CompoundNBT toNBT() {
        CompoundNBT ext = new CompoundNBT();
        ext.func_218657_a("Pos", (INBT)MiscUtil.serializeGlobalPos(this.gPos));
        ext.func_74774_a("Face", (byte)this.face.ordinal());
        ext.func_74778_a("InvName", this.blockTranslationKey);
        return ext;
    }

    public static ModuleTarget fromNBT(CompoundNBT nbt) {
        GlobalPos gPos = MiscUtil.deserializeGlobalPos(nbt.func_74775_l("Pos"));
        Direction face = Direction.values()[nbt.func_74771_c("Face")];
        return new ModuleTarget(gPos, face, nbt.func_74779_i("InvName"));
    }

    public boolean isSameWorld(World world) {
        return this.gPos.func_218177_a() == world.func_201675_m().func_186058_p();
    }

    public LazyOptional<IItemHandler> getItemHandler(World w) {
        return this.isSameWorld(w) ? this.getItemHandlerFor(w) : LazyOptional.empty();
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return this.getItemHandlerFor((World)MiscUtil.getWorldForGlobalPos(this.gPos));
    }

    private LazyOptional<IItemHandler> getItemHandlerFor(World w) {
        BlockPos pos = this.gPos.func_218180_b();
        if (w == null || !w.func_72863_F().func_73149_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
            return LazyOptional.empty();
        }
        TileEntity te = w.func_175625_s(pos);
        return te == null ? LazyOptional.empty() : te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.face);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleTarget)) {
            return false;
        }
        ModuleTarget that = (ModuleTarget)o;
        return this.gPos.equals((Object)that.gPos) && this.face == that.face;
    }

    public int hashCode() {
        return Objects.hash(this.gPos, this.face);
    }

    public String toString() {
        return MiscUtil.locToString(this.gPos.func_218177_a().func_186068_a(), this.gPos.func_218180_b()) + " " + this.face;
    }

    public ITextComponent getTextComponent() {
        return MiscUtil.xlate(this.blockTranslationKey, new Object[0]).func_211708_a(TextFormatting.WHITE).func_150258_a(" @ ").func_150258_a(MiscUtil.locToString(this.gPos.func_218177_a().func_186068_a(), this.gPos.func_218180_b()) + " " + this.face).func_211708_a(TextFormatting.AQUA);
    }
}

