/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.widgets;

import me.desht.modularrouters.client.gui.widgets.button.ITooltipButton;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiScreenBase
extends Screen {
    private TextFieldManager textFieldManager;
    private int delayTicks;

    protected GuiScreenBase(ITextComponent displayName) {
        super(displayName);
    }

    protected TextFieldManager getTextFieldManager() {
        if (this.textFieldManager == null) {
            this.textFieldManager = new TextFieldManager(this);
        }
        return this.textFieldManager;
    }

    protected boolean hasTextFieldManager() {
        return this.textFieldManager != null;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (this.textFieldManager != null) {
            this.textFieldManager.drawTextFields(mouseX, mouseY, partialTicks);
        }
        this.buttons.stream().filter(button -> button.isMouseOver((double)mouseX, (double)mouseY) && button instanceof ITooltipButton).forEach(button -> this.renderTooltip(((ITooltipButton)button).getTooltip(), mouseX, mouseY, this.font));
    }

    public void tick() {
        super.tick();
        if (this.delayTicks > 0) {
            --this.delayTicks;
            if (this.delayTicks == 0) {
                this.sendSettingsToServer();
            }
        }
        if (this.textFieldManager != null) {
            this.textFieldManager.tick();
        }
    }

    public boolean mouseScrolled(double x, double y, double dir) {
        return this.textFieldManager != null ? this.textFieldManager.mouseScrolled(dir) : super.mouseScrolled(x, y, dir);
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.textFieldManager != null && this.textFieldManager.mouseClicked(x, y, button)) {
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.textFieldManager != null && this.textFieldManager.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int modifiers) {
        if (this.textFieldManager != null && this.textFieldManager.charTyped(c, modifiers)) {
            return true;
        }
        return super.charTyped(c, modifiers);
    }

    public void removed() {
        if (this.delayTicks > 0) {
            this.sendSettingsToServer();
        }
        super.removed();
    }

    protected final void sendSettingsDelayed(int delayTicks) {
        this.delayTicks = delayTicks;
    }

    protected void sendSettingsToServer() {
    }
}

