/*
 * Decompiled with CFR 0.152.
 */
package cofh.omgourd.init;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class OMGConfig {
    private static boolean registered = false;
    private static final ForgeConfigSpec.Builder SERVER_CONFIG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec serverSpec;
    private static final ForgeConfigSpec.Builder CLIENT_CONFIG;
    private static ForgeConfigSpec clientSpec;
    public static ForgeConfigSpec.BooleanValue enableCreativeTab;

    public static void register() {
        if (registered) {
            return;
        }
        FMLJavaModLoadingContext.get().getModEventBus().register(OMGConfig.class);
        registered = true;
        OMGConfig.genClientConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, clientSpec);
    }

    private OMGConfig() {
    }

    private static void genServerConfig() {
        serverSpec = SERVER_CONFIG.build();
    }

    private static void genClientConfig() {
        String comment = "If TRUE, Oh My Gourd! will have its own Item Group (Creative Tab).";
        enableCreativeTab = CLIENT_CONFIG.comment(comment).define("Enable Item Group", true);
        clientSpec = CLIENT_CONFIG.build();
    }

    private static void refreshServerConfig() {
    }

    private static void refreshClientConfig() {
    }

    @SubscribeEvent
    public static void configLoading(ModConfig.Loading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                OMGConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                OMGConfig.refreshServerConfig();
            }
        }
    }

    @SubscribeEvent
    public static void configReloading(ModConfig.Reloading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                OMGConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                OMGConfig.refreshServerConfig();
            }
        }
    }

    static {
        CLIENT_CONFIG = new ForgeConfigSpec.Builder();
    }
}

