/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.net;

import com.feed_the_beast.mods.ftbchunks.FTBChunks;
import com.feed_the_beast.mods.ftbchunks.FTBChunksConfig;
import com.feed_the_beast.mods.ftbchunks.impl.AllyMode;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkPlayerDataImpl;
import com.feed_the_beast.mods.ftbchunks.impl.FTBChunksAPIImpl;
import com.feed_the_beast.mods.ftbchunks.impl.KnownFakePlayer;
import com.feed_the_beast.mods.ftbchunks.net.FTBChunksNet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class SendPlayerListPacket {
    public final List<NetPlayer> players;
    public final int allyMode;

    public SendPlayerListPacket(List<NetPlayer> p, int a) {
        this.players = p;
        this.allyMode = a;
    }

    SendPlayerListPacket(PacketBuffer buf) {
        int s = buf.func_150792_a();
        this.players = new ArrayList<NetPlayer>(s);
        for (int i = 0; i < s; ++i) {
            long most = buf.readLong();
            long least = buf.readLong();
            String name = buf.func_150789_c(50);
            int flags = buf.func_150792_a();
            this.players.add(new NetPlayer(new UUID(most, least), name, flags));
        }
        this.allyMode = buf.readUnsignedByte();
    }

    public static void send(ServerPlayerEntity player) {
        ClaimedChunkPlayerDataImpl self = FTBChunksAPIImpl.manager.getData(player);
        int allyMode = FTBChunksConfig.allyMode == AllyMode.FORCED_ALL ? 2 : (FTBChunksConfig.allyMode == AllyMode.FORCED_NONE ? 3 : 0);
        ArrayList<NetPlayer> players = new ArrayList<NetPlayer>();
        ClaimedChunkPlayerDataImpl server = FTBChunksAPIImpl.manager.getServerData();
        for (ClaimedChunkPlayerDataImpl claimedChunkPlayerDataImpl : FTBChunksAPIImpl.manager.playerData.values()) {
            if (claimedChunkPlayerDataImpl == server || claimedChunkPlayerDataImpl == self) continue;
            players.add(new NetPlayer(claimedChunkPlayerDataImpl.getUuid(), claimedChunkPlayerDataImpl.getName(), self.allies.contains(claimedChunkPlayerDataImpl.getUuid()) ? 2 : 0));
        }
        for (KnownFakePlayer knownFakePlayer : FTBChunksAPIImpl.manager.knownFakePlayers.values()) {
            players.add(new NetPlayer(knownFakePlayer.uuid, knownFakePlayer.name, 1 | (knownFakePlayer.banned ? 4 : 0) | (self.allies.contains(knownFakePlayer.uuid) ? 2 : 0)));
        }
        players.sort(null);
        FTBChunksNet.MAIN.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SendPlayerListPacket(players, allyMode));
    }

    void write(PacketBuffer buf) {
        buf.func_150787_b(this.players.size());
        for (NetPlayer p : this.players) {
            buf.writeLong(p.uuid.getMostSignificantBits());
            buf.writeLong(p.uuid.getLeastSignificantBits());
            buf.func_211400_a(p.name, 50);
            buf.func_150787_b(p.flags);
        }
        buf.writeByte(this.allyMode);
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> FTBChunks.instance.proxy.openPlayerList(this));
        context.get().setPacketHandled(true);
    }

    public static class NetPlayer
    implements Comparable<NetPlayer> {
        public static final int FAKE = 1;
        public static final int ALLY = 2;
        public static final int BANNED = 4;
        public final UUID uuid;
        public final String name;
        public final int flags;

        public NetPlayer(UUID u, String n, int f) {
            this.uuid = u;
            this.name = n;
            this.flags = f;
        }

        public boolean isFake() {
            return (this.flags & 1) != 0;
        }

        public boolean isAlly() {
            return (this.flags & 2) != 0;
        }

        public boolean isBanned() {
            return (this.flags & 4) != 0;
        }

        @Override
        public int compareTo(NetPlayer o) {
            int i = Boolean.compare(this.isFake(), o.isFake());
            return i == 0 ? this.name.compareToIgnoreCase(o.name) : i;
        }
    }
}

