/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.impl.map;

import com.feed_the_beast.mods.ftbchunks.impl.FTBChunksAPIImpl;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapDimension;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapRegion;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapTask;
import com.feed_the_beast.mods.ftbchunks.impl.map.ReloadChunkTask;
import com.feed_the_beast.mods.ftbchunks.impl.map.XZ;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.server.ServerWorld;

public class PregenMapRegionTask
implements MapTask,
ReloadChunkTask.Callback {
    public final ServerWorld world;

    public PregenMapRegionTask(ServerWorld w) {
        this.world = w;
    }

    @Override
    public void run() {
        try {
            File regionFolder = new File(this.world.func_201675_m().func_186058_p().func_212679_a(this.world.func_217485_w().func_75765_b()), "region");
            if (!regionFolder.exists() || !regionFolder.isDirectory()) {
                return;
            }
            MapDimension dimension = FTBChunksAPIImpl.manager.map.getDimension(this.world.func_201675_m().func_186058_p());
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
            for (File file : regionFolder.listFiles()) {
                String[] s;
                if (!file.isFile() || (s = file.getName().split("\\.")).length != 4 || !s[0].equals("r") || !s[3].equals("mca")) continue;
                try {
                    MapRegion region = dimension.getRegion(XZ.of(Integer.parseInt(s[1]), Integer.parseInt(s[2])));
                    RegionFile regionFile = new RegionFile(file, regionFolder);
                    for (int z = 0; z < 32; ++z) {
                        for (int x = 0; x < 32; ++x) {
                            ChunkPos cpos = new ChunkPos((region.pos.x << 5) + x, (region.pos.z << 5) + z);
                            if (!regionFile.func_222667_d(cpos)) continue;
                            chunks.add(cpos);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            for (ChunkPos pos : chunks) {
                new ReloadChunkTask((World)this.world, XZ.of(pos), this).run();
            }
            this.world.func_73046_m().func_184103_al().func_148539_a((ITextComponent)new StringTextComponent("Map pre-generation is done!"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean cancelOtherTasks() {
        return true;
    }

    @Override
    public void accept(ReloadChunkTask task, boolean changed) {
    }
}

