/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.init;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import xreliquary.compat.ICompat;
import xreliquary.compat.curios.CuriosCompat;
import xreliquary.compat.waila.WailaCompat;
import xreliquary.util.LogHelper;

@Mod.EventBusSubscriber(modid="xreliquary", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModCompat {
    private static Map<String, Supplier<Callable<ICompat>>> compatFactories = new HashMap<String, Supplier<Callable<ICompat>>>();
    private static Set<ICompat> loadedCompats;

    private ModCompat() {
    }

    public static void initCompats() {
        for (Map.Entry<String, Supplier<Callable<ICompat>>> entry : compatFactories.entrySet()) {
            if (!ModList.get().isLoaded(entry.getKey())) continue;
            try {
                loadedCompats.add(entry.getValue().get().call());
            }
            catch (Exception e) {
                LogHelper.error("Error instantiating compatibility ", e);
            }
        }
    }

    public static void setupCompats() {
        loadedCompats.forEach(ICompat::setup);
    }

    static {
        compatFactories.put("waila", () -> WailaCompat::new);
        compatFactories.put("hwyla", () -> WailaCompat::new);
        compatFactories.put("curios", () -> CuriosCompat::new);
        loadedCompats = new HashSet<ICompat>();
    }
}

