/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;

public class ColorParticleData
implements IParticleData {
    private ParticleType<ColorParticleData> particleType;
    private final float red;
    private final float green;
    private final float blue;
    public static final IParticleData.IDeserializer<ColorParticleData> DESERIALIZER = new IParticleData.IDeserializer<ColorParticleData>(){

        public ColorParticleData deserialize(ParticleType<ColorParticleData> particleType, StringReader stringReader) throws CommandSyntaxException {
            stringReader.expect(' ');
            float r = stringReader.readFloat();
            stringReader.expect(' ');
            float g = stringReader.readFloat();
            stringReader.expect(' ');
            float b = stringReader.readFloat();
            stringReader.expect(' ');
            return new ColorParticleData(particleType, r, g, b);
        }

        public ColorParticleData read(ParticleType<ColorParticleData> particleType, PacketBuffer packetBuffer) {
            return new ColorParticleData(particleType, packetBuffer.readFloat(), packetBuffer.readFloat(), packetBuffer.readFloat());
        }
    };

    public ColorParticleData(ParticleType<ColorParticleData> particleType, float red, float green, float blue) {
        this.particleType = particleType;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public ParticleType<?> func_197554_b() {
        return this.particleType;
    }

    public void func_197553_a(PacketBuffer packetBuffer) {
        packetBuffer.writeFloat(this.red);
        packetBuffer.writeFloat(this.green);
        packetBuffer.writeFloat(this.blue);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", this.func_197554_b().getRegistryName(), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }
}

