/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client.gui.components;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public abstract class Component {
    public int getPadding() {
        return 1;
    }

    public int getHeight() {
        return this.getHeightInternal() + this.getPadding() * 2;
    }

    public int getWidth() {
        return this.getWidthInternal() + this.getPadding() * 2;
    }

    public void render(int x, int y) {
        this.renderInternal(x + this.getPadding(), y + this.getPadding());
    }

    public boolean shouldRender() {
        return true;
    }

    public abstract int getHeightInternal();

    public abstract int getWidthInternal();

    public abstract void renderInternal(int var1, int var2);

    protected void blit(int x, int y, int textureX, int textureY, int width, int height) {
        this.blit(x, y, textureX, textureY, width, height, 256.0f, 256.0f);
    }

    protected void blit(int x, int y, int textureX, int textureY, int width, int height, float textureWidth, float textureHeight) {
        float minU = (float)textureX / textureWidth;
        float maxU = (float)(textureX + width) / textureWidth;
        float minV = (float)textureY / textureHeight;
        float maxV = (float)(textureY + height) / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)x, (double)(y + height), 0.0).func_225583_a_(minU, maxV).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_(maxU, maxV).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, 0.0).func_225583_a_(maxU, minV).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_225583_a_(minU, minV).func_181675_d();
        tessellator.func_78381_a();
    }
}

