/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import xreliquary.blocks.tile.ApothecaryMortarTileEntity;
import xreliquary.blocks.tile.PassivePedestalTileEntity;
import xreliquary.blocks.tile.PedestalTileEntity;
import xreliquary.client.init.ModBlockColors;
import xreliquary.client.init.ModItemColors;
import xreliquary.client.registry.PedestalClientRegistry;
import xreliquary.client.render.ApothecaryMortarRenderer;
import xreliquary.client.render.LyssaHookRenderer;
import xreliquary.client.render.PassivePedestalRenderer;
import xreliquary.client.render.PedestalFishHookRenderer;
import xreliquary.client.render.PedestalRenderer;
import xreliquary.client.render.ShotRenderer;
import xreliquary.client.render.XRTippedArrowRenderer;
import xreliquary.common.CommonProxy;
import xreliquary.compat.jei.descriptions.JEIDescriptionRegistry;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModEntities;
import xreliquary.items.FortuneCoinToggler;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="xreliquary", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy
extends CommonProxy {
    public static final KeyBinding FORTUNE_COIN_TOGGLE_KEYBIND = new KeyBinding("keybind.xreliquary.fortune_coin", InputMappings.field_197958_a.func_197937_c(), "keybind.xreliquary.category");

    @Override
    public void registerHandlers() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
    }

    @Override
    public void registerJEI(Block block, String name) {
        if (ModList.get().isLoaded("jei")) {
            JEIDescriptionRegistry.register(Item.func_150898_a((Block)block), name);
        }
    }

    @Override
    public void registerJEI(Supplier<List<ItemStack>> items, String ... names) {
        if (ModList.get().isLoaded("jei")) {
            JEIDescriptionRegistry.register(items, names);
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.LYSSA_HOOK, LyssaHookRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BLAZE_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BUSTER_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.CONCUSSIVE_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.ENDER_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.EXORCISM_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.NEUTRAL_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.SEEKER_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.SAND_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.STORM_SHOT, ShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.TIPPED_ARROW, XRTippedArrowRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.GLOWING_WATER, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.APHRODITE_POTION, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.FERTILE_POTION, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.HOLY_HAND_GRENADE, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.KRAKEN_SLIME, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.SPECIAL_SNOWBALL, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.ENDER_STAFF_PROJECTILE, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.THROWN_POTION, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        ClientProxy.registerTileRenderers();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DeferredWorkQueue.runLater(() -> ClientRegistry.registerKeyBinding((KeyBinding)FORTUNE_COIN_TOGGLE_KEYBIND));
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.FERTILE_LILY_PAD, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.INTERDICTION_TORCH, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.WALL_INTERDICTION_TORCH, (RenderType)RenderType.func_228643_e_());
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        DeferredWorkQueue.runLater(() -> {
            ModItemColors.init();
            ModBlockColors.init();
            PedestalClientRegistry.registerItemRenderer(FishingRodItem.class, PedestalFishHookRenderer.class);
            MinecraftForge.EVENT_BUS.addListener(FortuneCoinToggler::handleKeyInputEvent);
        });
    }

    private static void registerTileRenderers() {
        ClientRegistry.bindTileEntityRenderer(ApothecaryMortarTileEntity.TYPE, ApothecaryMortarRenderer::new);
        ClientRegistry.bindTileEntityRenderer(PedestalTileEntity.TYPE, PedestalRenderer::new);
        ClientRegistry.bindTileEntityRenderer(PassivePedestalTileEntity.TYPE, PassivePedestalRenderer::new);
    }
}

