/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.subscribe.events;

import com.maciej916.maessentials.common.data.DataManager;
import com.maciej916.maessentials.common.lib.player.EssentialPlayer;
import com.maciej916.maessentials.common.lib.player.PlayerRestriction;
import com.maciej916.maessentials.common.util.TextUtils;
import com.maciej916.maessentials.common.util.TimeUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="maessentials", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventServerChat {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerChat(ServerChatEvent event) {
        ServerPlayerEntity player = event.getPlayer();
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        PlayerRestriction mute = eslPlayer.getRestrictions().getMute();
        if (mute != null && (mute.getTime() == -1L || mute.getTime() > TimeUtils.currentTimestamp())) {
            if (mute.getTime() == -1L) {
                TextUtils.sendMessage(player, "mute.maessentials.success.perm.target", new Object[0]);
            } else {
                String displayTime = TimeUtils.formatDate(mute.getTime() - TimeUtils.currentTimestamp());
                TextUtils.sendMessage(player, "mute.maessentials.success.target", displayTime);
            }
            TextUtils.sendMessage(player, "mute.maessentials.success.target.reason", mute.getReason());
            event.setCanceled(true);
        }
    }
}

