/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.subscribe.events;

import com.maciej916.maessentials.common.config.ModConfig;
import com.maciej916.maessentials.common.data.DataManager;
import com.maciej916.maessentials.common.lib.Location;
import com.maciej916.maessentials.common.lib.kit.Kit;
import com.maciej916.maessentials.common.lib.player.EssentialPlayer;
import com.maciej916.maessentials.common.lib.player.PlayerRestriction;
import com.maciej916.maessentials.common.util.LogUtils;
import com.maciej916.maessentials.common.util.ModUtils;
import com.maciej916.maessentials.common.util.TeleportUtils;
import com.maciej916.maessentials.common.util.TimeUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="maessentials", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventPlayerLoggedIn {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        EssentialPlayer eslPlayer = DataManager.newPlayer(player);
        if (eslPlayer != null) {
            Kit kit;
            Location spawnLocation;
            LogUtils.debug("New player " + player.func_145748_c_().getString() + " joined");
            if (player.func_184102_h().func_71262_S() && (spawnLocation = DataManager.getWorld().getSpawn()) != null) {
                TeleportUtils.doTeleport(player, spawnLocation, true, false);
            }
            if (ModConfig.kits_starting.booleanValue() && ModUtils.giveKit(player, kit = DataManager.getKit().getKit(ModConfig.kits_starting_name))) {
                eslPlayer.getUsage().setKitUssage(ModConfig.kits_starting_name);
                eslPlayer.saveData();
            }
        } else {
            EssentialPlayer eslPlayerExisted = DataManager.getPlayer(player);
            PlayerRestriction ban = eslPlayerExisted.getRestrictions().getBan();
            if (ban != null) {
                if (ban.getTime() == -1L) {
                    player.field_71135_a.func_194028_b((ITextComponent)new TranslationTextComponent("tempban.maessentials.success.perm.target", new Object[]{player.func_145748_c_(), ban.getReason()}));
                } else if (ban.getTime() > TimeUtils.currentTimestamp()) {
                    String displayTime = TimeUtils.formatDate(ban.getTime() - TimeUtils.currentTimestamp());
                    player.field_71135_a.func_194028_b((ITextComponent)new TranslationTextComponent("tempban.maessentials.success.target", new Object[]{player.func_145748_c_(), displayTime, ban.getReason()}));
                }
            }
            LogUtils.debug("Player " + player.func_145748_c_().getString() + " joined");
        }
        EssentialPlayer eslPlayerNew = DataManager.getPlayer(player);
        eslPlayerNew.setUsername(player.func_145748_c_().getString());
        eslPlayerNew.saveData();
    }
}

