/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.lib.teleport;

import com.maciej916.maessentials.common.config.ModConfig;
import com.maciej916.maessentials.common.lib.Location;
import com.maciej916.maessentials.common.util.TimeUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;

public class TeleportRequest {
    private ServerPlayerEntity creator;
    private ServerPlayerEntity player;
    private ServerPlayerEntity target;
    private long timeout;
    private long delay;
    private long teleportTime;
    private boolean accepted = false;

    public TeleportRequest(ServerPlayerEntity creator, ServerPlayerEntity player, ServerPlayerEntity target, long delay) {
        this.creator = creator;
        this.player = player;
        this.target = target;
        this.delay = delay;
        this.timeout = TimeUtils.currentTimestamp() + delay;
    }

    public ServerPlayerEntity getCreator() {
        return this.creator;
    }

    public ServerPlayerEntity getPlayer() {
        return this.player;
    }

    public ITextComponent getPlayerName() {
        return this.player.func_145748_c_();
    }

    public ServerPlayerEntity getTarget() {
        return this.target;
    }

    public ITextComponent getTargetName() {
        return this.target.func_145748_c_();
    }

    public Location getDestination() {
        return new Location(this.target);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getDelay() {
        return this.delay;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted() {
        this.teleportTime = TimeUtils.currentTimestamp() + (long)ModConfig.tpa_delay.intValue();
        this.accepted = true;
    }

    public long getTeleportTime() {
        return this.teleportTime;
    }
}

