/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.client.gui;

import com.maciej916.maessentials.client.gui.base.GuiElement;
import com.maciej916.maessentials.client.interfaces.IGuiWrapper;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class ModGui<CONTAINER extends Container>
extends ContainerScreen<CONTAINER>
implements IGuiWrapper {
    public ModGui(CONTAINER screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
    }

    @Override
    public int getStringWidth(ITextComponent component) {
        return this.getStringWidth(component.func_150254_d());
    }

    @Override
    public int getStringWidth(String text) {
        return this.font.func_78256_a(text);
    }

    @Override
    public int drawString(ITextComponent component, int x, int y, int color) {
        return this.drawString(component.func_150254_d(), x, y, color);
    }

    @Override
    public int drawString(String text, int x, int y, int color) {
        return this.font.func_211126_b(text, (float)x, (float)y, color);
    }

    @Override
    public void drawCenteredText(ITextComponent component, int leftMargin, int y, int color) {
        this.drawCenteredText(component, leftMargin, 0, y, color);
    }

    @Override
    public void drawCenteredText(ITextComponent component, int leftMargin, int areaWidth, int y, int color) {
        int textWidth = this.getStringWidth(component);
        int centerX = leftMargin + areaWidth / 2 - textWidth / 2;
        this.drawString(component, centerX, y, color);
    }

    @Override
    public void renderScaledText(ITextComponent component, int x, int y, int color, int maxX) {
        this.renderScaledText(component.func_150254_d(), x, y, color, maxX);
    }

    @Override
    public void renderScaledText(String text, int x, int y, int color, int maxX) {
        int length = this.getStringWidth(text);
        if (length <= maxX) {
            this.drawString(text, x, y, color);
        } else {
            float scale = (float)maxX / (float)length;
            float reverse = 1.0f / scale;
            float yAdd = 4.0f - scale * 8.0f / 2.0f;
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)scale, (float)scale, (float)scale);
            this.drawString(text, (int)((float)x * reverse), (int)((float)y * reverse + yAdd), color);
            RenderSystem.popMatrix();
        }
    }

    @Override
    public void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    protected void drawGuiTitleText() {
        this.drawCenteredText(this.title, 0, this.getXSize(), 6, 0x404040);
        this.drawString(this.field_213127_e.func_145748_c_(), 8, this.getYSize() - 96 + 2, 0x404040);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawGuiTitleText();
        int xAxis = mouseX - this.getGuiLeft();
        int yAxis = mouseY - this.getGuiTop();
        for (Widget widget : this.buttons) {
            if (!(widget instanceof GuiElement)) continue;
            ((GuiElement)widget).renderForeground(mouseX, mouseY, xAxis, yAxis);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture(this.getGuiLocation());
        this.drawRect(this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
    }

    @Override
    public FontRenderer getFont() {
        return this.font;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    @Override
    public void drawRect(int x, int y, int textureX, int textureY, int width, int height) {
        this.blit(x, y, textureX, textureY, width, height);
    }

    @Override
    public void drawRectFromIcon(int x, int y, TextureAtlasSprite icon, int width, int height) {
        ModGui.blit((int)x, (int)y, (int)this.getBlitOffset(), (int)width, (int)height, (TextureAtlasSprite)icon);
    }

    protected abstract ResourceLocation getGuiLocation();
}

