/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.gui;

import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.SharedConstants;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import technicianlp.reauth.ReAuth;

final class PasswordFieldWidget
extends TextFieldWidget {
    private static final Field selectionEnd = ObfuscationReflectionHelper.findField(TextFieldWidget.class, (String)"field_146223_s");
    private char[] password = new char[0];

    PasswordFieldWidget(FontRenderer renderer, int posx, int posy, int x, int y, String name) {
        super(renderer, posx, posy, x, y, name);
        this.func_146203_f(512);
    }

    final char[] getPW() {
        char[] pw = new char[this.password.length];
        System.arraycopy(this.password, 0, pw, 0, this.password.length);
        return pw;
    }

    public final boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isFocused() || Screen.isCopy((int)keyCode) || Screen.isCut((int)keyCode)) {
            return false;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        if (!this.func_212955_f()) {
            return false;
        }
        if (this.isAllowedCharacter(p_charTyped_1_)) {
            this.func_146191_b(Character.toString(p_charTyped_1_));
            return true;
        }
        return false;
    }

    public final void func_146191_b(String rawInput) {
        int selectionEnd = this.getSelectionEnd();
        int selStart = Math.min(this.func_146198_h(), selectionEnd);
        int selEnd = Math.max(this.func_146198_h(), selectionEnd);
        int selLength = selEnd - selStart;
        char[] input = this.filterAllowedCharacters(rawInput);
        char[] newPW = new char[this.password.length - selLength + input.length];
        if (this.password.length != 0 && selStart > 0) {
            System.arraycopy(this.password, 0, newPW, 0, Math.min(selStart, this.password.length));
        }
        System.arraycopy(input, 0, newPW, selStart, input.length);
        if (this.password.length != 0 && selEnd < this.password.length) {
            System.arraycopy(this.password, selEnd, newPW, selStart + input.length, this.password.length - selEnd);
        }
        this.setPassword(newPW);
        this.func_212422_f(selStart + input.length);
        this.func_146199_i(this.func_146198_h());
    }

    public final void func_146175_b(int num) {
        if (this.password.length == 0) {
            return;
        }
        if (this.getSelectionEnd() != this.func_146198_h()) {
            this.func_146191_b("");
        } else {
            boolean direction = num < 0;
            int start = direction ? Math.max(this.func_146198_h() + num, 0) : this.func_146198_h();
            int end = direction ? this.func_146198_h() : Math.min(this.func_146198_h() + num, this.password.length);
            char[] newPW = new char[start + this.password.length - end];
            if (start >= 0) {
                System.arraycopy(this.password, 0, newPW, 0, start);
            }
            if (end < this.password.length) {
                System.arraycopy(this.password, end, newPW, start, this.password.length - end);
            }
            if (direction) {
                this.func_146182_d(num);
            }
            this.setPassword(newPW);
        }
    }

    final void setPassword(char[] password) {
        Arrays.fill(this.password, 'f');
        this.password = password;
        this.updateText();
    }

    public final void func_146180_a(String textIn) {
        this.setPassword(textIn.toCharArray());
        this.updateText();
    }

    private void updateText() {
        char[] chars = new char[this.password.length];
        Arrays.fill(chars, '\u25cf');
        super.func_146180_a(new String(chars));
    }

    private char[] filterAllowedCharacters(String input) {
        char[] out = new char[input.length()];
        int outInd = 0;
        for (int i = 0; i < out.length; ++i) {
            char in = input.charAt(i);
            if (!this.isAllowedCharacter(in)) continue;
            out[outInd++] = in;
        }
        char[] ret = new char[outInd];
        System.arraycopy(out, 0, ret, 0, outInd);
        Arrays.fill(out, 'f');
        return ret;
    }

    private boolean isAllowedCharacter(char in) {
        return in == '\u00a7' || SharedConstants.func_71566_a((char)in);
    }

    public int getSelectionEnd() {
        return (Integer)ReAuth.getField(selectionEnd, (Object)this);
    }
}

