/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.resourceproduction.MarineFisherConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.energy.NBTEnergyHandler;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.items.ItemHandlerHelper;

public class MarineFisherTile
extends IndustrialAreaWorkingTile<MarineFisherTile> {
    private int maxProgress;
    private int powerPerOperation;
    @Save
    private SidedInventoryComponent<MarineFisherTile> output = (SidedInventoryComponent)new SidedInventoryComponent("output", 50, 22, 18, 0).setColor(DyeColor.ORANGE).setRange(6, 3).setComponentHarness((IComponentHarness)this);

    public MarineFisherTile() {
        super(ModuleResourceProduction.MARINE_FISHER, RangeManager.RangeType.BOTTOM, false);
        this.addInventory((InventoryComponent)this.output);
        this.maxProgress = MarineFisherConfig.maxProgress;
        this.powerPerOperation = MarineFisherConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(this.powerPerOperation)) {
            if (this.getWaterSources() < 9) {
                return new IndustrialWorkingTile.WorkAction(1.0f, 0);
            }
            LootTable fishingTable = this.field_145850_b.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186387_al);
            LootContext.Builder context = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216015_a(LootParameters.field_216286_f, (Object)this.field_174879_c).func_216015_a(LootParameters.field_216289_i, (Object)new ItemStack((IItemProvider)Items.field_151112_aM));
            fishingTable.func_216113_a(context.func_216022_a(LootParameterSets.field_216262_c)).forEach(stack -> ItemHandlerHelper.insertItem(this.output, (ItemStack)stack, (boolean)false));
            return new IndustrialWorkingTile.WorkAction(1.0f, this.powerPerOperation);
        }
        return new IndustrialWorkingTile.WorkAction(1.0f, 0);
    }

    protected IFactory<NBTEnergyHandler> getEnergyHandlerFactory() {
        return () -> new NBTEnergyHandler((BasicTile)this, MarineFisherConfig.maxStoredPower);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public MarineFisherTile getSelf() {
        return this;
    }

    @Override
    public VoxelShape getWorkingArea() {
        return new RangeManager(this.field_174879_c, this.getFacingDirection(), RangeManager.RangeType.BOTTOM).get(1);
    }

    private int getWaterSources() {
        int amount = 0;
        for (BlockPos pos : BlockUtils.getBlockPosInAABB(this.getWorkingArea().func_197752_a())) {
            IFluidState fluidState;
            if (!this.field_145850_b.func_175707_a(pos, pos) || !(fluidState = this.field_145850_b.func_204610_c(pos)).func_206886_c().equals(Fluids.field_204546_a) || !fluidState.func_206889_d()) continue;
            ++amount;
        }
        return amount;
    }
}

