/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.PlantSowerConfig;
import com.buuz135.industrial.item.RangeAddonItem;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.IAugment;
import com.hrznstudio.titanium.api.filter.FilterSlot;
import com.hrznstudio.titanium.api.filter.IFilter;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.energy.NBTEnergyHandler;
import com.hrznstudio.titanium.filter.ItemStackFilter;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.IPlantable;

public class PlantSowerTile
extends IndustrialAreaWorkingTile<PlantSowerTile> {
    public static DyeColor[] COLORS = new DyeColor[]{DyeColor.RED, DyeColor.YELLOW, DyeColor.LIME, DyeColor.CYAN, DyeColor.WHITE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.BLACK};
    private int maxProgress;
    private int powerPerOperation;
    @Save
    private ItemStackFilter filter = new ItemStackFilter("filter", 9){

        public void onContentChanged() {
            super.onContentChanged();
            PlantSowerTile.this.markForUpdate();
        }
    };
    @Save
    private SidedInventoryComponent<PlantSowerTile> input;

    public PlantSowerTile() {
        super(ModuleAgricultureHusbandry.PLANT_SOWER, RangeManager.RangeType.TOP_UP, true);
        this.addFilter((IFilter)this.filter);
        int pos = 0;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                FilterSlot slot = new FilterSlot(45 + x * 18, 21 + y * 18, pos, (Object)ItemStack.field_190927_a);
                slot.setColor(COLORS[pos]);
                this.filter.setFilter(pos, slot);
                ++pos;
            }
        }
        this.input = (SidedInventoryComponent)new SidedInventoryComponent("input", 108, 22, 9, 0).setColor(DyeColor.CYAN).setInputFilter((itemStack, integer) -> itemStack.func_77973_b() instanceof BlockItem && ((BlockItem)itemStack.func_77973_b()).func_179223_d() instanceof IPlantable).setRange(3, 3).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.input);
        this.maxProgress = PlantSowerConfig.maxProgress;
        this.powerPerOperation = PlantSowerConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        BlockPos pos = this.getPointedBlockPos();
        if (this.isLoaded(pos) && this.field_145850_b.func_175623_d(pos) && this.hasEnergy(this.powerPerOperation)) {
            int slot = this.getFilteredSlot(pos);
            ItemStack stack = ItemStack.field_190927_a;
            for (int i = 0; i < this.input.getSlots(); ++i) {
                if (this.input.getStackInSlot(i).func_190926_b() || !((ItemStack)this.filter.getFilterSlots()[slot].getFilter()).func_190926_b() && !((ItemStack)this.filter.getFilterSlots()[slot].getFilter()).func_77969_a(this.input.getStackInSlot(i))) continue;
                stack = this.input.getStackInSlot(i);
                break;
            }
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof IPlantable) {
                Block block = ((BlockItem)stack.func_77973_b()).func_179223_d();
                if (this.field_145850_b.func_180495_p(pos.func_177977_b()).canSustainPlant((IBlockReader)this.field_145850_b, pos.func_177977_b(), Direction.UP, (IPlantable)block) && this.field_145850_b.func_175656_a(pos, ((IPlantable)block).getPlant((IBlockReader)this.field_145850_b, pos))) {
                    stack.func_190918_g(1);
                    this.increasePointer();
                    return new IndustrialWorkingTile.WorkAction(0.2f, this.powerPerOperation);
                }
            }
        }
        this.increasePointer();
        if (this.hasEnergy(this.powerPerOperation)) {
            return new IndustrialWorkingTile.WorkAction(0.4f, this.powerPerOperation / 50);
        }
        return new IndustrialWorkingTile.WorkAction(1.0f, 0);
    }

    private int getFilteredSlot(BlockPos pos) {
        int radius;
        int n = radius = this.hasAugmentInstalled(RangeAddonItem.RANGE) ? (int)((IAugment)this.getInstalledAugments(RangeAddonItem.RANGE).get(0)).getAugmentRatio() + 1 : 0;
        if (radius == 0) {
            for (int i = 0; i < this.input.getSlots(); ++i) {
                if (this.input.getStackInSlot(i).func_190926_b()) continue;
                return i;
            }
        }
        int x = Math.round(1.49f * (float)(pos.func_177958_n() - this.field_174879_c.func_177958_n()) / (float)radius);
        int z = Math.round(1.49f * (float)(pos.func_177952_p() - this.field_174879_c.func_177952_p()) / (float)radius);
        return 4 + x + 3 * z;
    }

    protected IFactory<NBTEnergyHandler> getEnergyHandlerFactory() {
        return () -> new NBTEnergyHandler((BasicTile)this, PlantSowerConfig.maxStoredPower);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public PlantSowerTile getSelf() {
        return this;
    }
}

