/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LogicFacing;
import mcjty.lib.varia.NamedEnum;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockSetup;
import mcjty.rftoolsutility.modules.logic.tools.AreaType;
import mcjty.rftoolsutility.modules.logic.tools.GroupType;
import mcjty.rftoolsutility.modules.logic.tools.SensorType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.items.CapabilityItemHandler;

public class SensorTileEntity
extends LogicTileEntity
implements ITickableTileEntity {
    public static final String CMD_SETNUMBER = "sensor.setNumber";
    public static final String CMD_SETTYPE = "sensor.setType";
    public static final String CMD_SETAREA = "sensor.setArea";
    public static final String CMD_SETGROUP = "sensor.setGroup";
    public static final String CONTAINER_INVENTORY = "container";
    public static final int SLOT_ITEMMATCH = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.ghost(), CONTAINER_INVENTORY, 0, 154, 24).playerSlots(10, 70));
    private NoDirectionItemHander items = this.createItemHandler();
    private LazyOptional<NoDirectionItemHander> itemHandler = LazyOptional.of(() -> this.items);
    private LazyOptional<AutomationFilterItemHander> automationItemHandler = LazyOptional.of(() -> new AutomationFilterItemHander(this.items));
    private LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Sensor").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)LogicBlockSetup.CONTAINER_SENSOR.get(), windowId.intValue(), (ContainerFactory)CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this)).itemHandler(this.itemHandler));
    private int number = 0;
    private SensorType sensorType = SensorType.SENSOR_BLOCK;
    private AreaType areaType = AreaType.AREA_1;
    private GroupType groupType = GroupType.GROUP_ONE;
    private int checkCounter = 0;
    private AxisAlignedBB cachedBox = null;

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(SensorTileEntity::new));
    }

    public SensorTileEntity() {
        super((TileEntityType)LogicBlockSetup.TYPE_SENSOR.get());
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
        this.cachedBox = null;
        this.markDirtyClient();
    }

    public SensorType getSensorType() {
        return this.sensorType;
    }

    public void setSensorType(SensorType sensorType) {
        this.sensorType = sensorType;
        this.cachedBox = null;
        this.markDirtyClient();
    }

    public AreaType getAreaType() {
        return this.areaType;
    }

    public void setAreaType(AreaType areaType) {
        this.areaType = areaType;
        this.cachedBox = null;
        this.markDirtyClient();
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public void setGroupType(GroupType groupType) {
        this.groupType = groupType;
        this.cachedBox = null;
        this.markDirtyClient();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.checkCounter;
        if (this.checkCounter > 0) {
            return;
        }
        this.checkCounter = 10;
        this.setRedstoneState(this.checkSensor() ? 15 : 0);
    }

    public boolean checkSensor() {
        boolean newout;
        LogicFacing facing = this.getFacing(this.field_145850_b.func_180495_p(this.func_174877_v()));
        Direction inputSide = facing.getInputSide();
        BlockPos newpos = this.func_174877_v().func_177972_a(inputSide);
        switch (this.sensorType) {
            case SENSOR_BLOCK: {
                newout = this.checkBlockOrFluid(newpos, facing, inputSide, this::checkBlock);
                break;
            }
            case SENSOR_FLUID: {
                newout = this.checkBlockOrFluid(newpos, facing, inputSide, this::checkFluid);
                break;
            }
            case SENSOR_GROWTHLEVEL: {
                newout = this.checkGrowthLevel(newpos, facing, inputSide);
                break;
            }
            case SENSOR_ENTITIES: {
                newout = this.checkEntities(newpos, facing, inputSide, Entity.class);
                break;
            }
            case SENSOR_PLAYERS: {
                newout = this.checkEntities(newpos, facing, inputSide, PlayerEntity.class);
                break;
            }
            case SENSOR_HOSTILE: {
                newout = this.checkEntitiesHostile(newpos, facing, inputSide);
                break;
            }
            case SENSOR_PASSIVE: {
                newout = this.checkEntitiesPassive(newpos, facing, inputSide);
                break;
            }
            default: {
                newout = false;
            }
        }
        return newout;
    }

    private boolean checkBlockOrFluid(BlockPos newpos, LogicFacing facing, Direction dir, Function<BlockPos, Boolean> blockChecker) {
        int blockCount = this.areaType.getBlockCount();
        if (blockCount > 0) {
            Boolean x = this.checkBlockOrFluidRow(newpos, dir, blockChecker, blockCount);
            if (x != null) {
                return x;
            }
        } else if (blockCount < 0) {
            Direction downSide = facing.getSide();
            Direction inputSide = facing.getInputSide();
            Direction rightSide = LogicSlabBlock.rotateLeft((Direction)downSide, (Direction)inputSide);
            Direction leftSide = LogicSlabBlock.rotateRight((Direction)downSide, (Direction)inputSide);
            Boolean x = this.checkBlockOrFluidRow(newpos, dir, blockChecker, blockCount = -blockCount);
            if (x != null) {
                return x;
            }
            for (int i = 1; i <= (blockCount - 1) / 2; ++i) {
                BlockPos p = newpos.func_177967_a(leftSide, i);
                x = this.checkBlockOrFluidRow(p, dir, blockChecker, blockCount);
                if (x != null) {
                    return x;
                }
                p = newpos.func_177967_a(rightSide, i);
                x = this.checkBlockOrFluidRow(p, dir, blockChecker, blockCount);
                if (x == null) continue;
                return x;
            }
        }
        return this.groupType == GroupType.GROUP_ALL;
    }

    private Boolean checkBlockOrFluidRow(BlockPos newpos, Direction dir, Function<BlockPos, Boolean> blockChecker, int count) {
        for (int i = 0; i < count; ++i) {
            boolean result = blockChecker.apply(newpos);
            if (result && this.groupType == GroupType.GROUP_ONE) {
                return true;
            }
            if (!result && this.groupType == GroupType.GROUP_ALL) {
                return false;
            }
            newpos = newpos.func_177972_a(dir);
        }
        return null;
    }

    private boolean checkBlock(BlockPos newpos) {
        BlockState state = this.field_145850_b.func_180495_p(newpos);
        ItemStack matcher = this.items.getStackInSlot(0);
        if (matcher.func_190926_b()) {
            return state.func_177230_c().func_149688_o(state).func_76220_a();
        }
        ItemStack stack = state.func_177230_c().func_185473_a((IBlockReader)this.field_145850_b, newpos, state);
        if (!stack.func_190926_b()) {
            return matcher.func_77973_b() == stack.func_77973_b();
        }
        return matcher.func_77973_b() == Item.func_150898_a((Block)state.func_177230_c());
    }

    private boolean checkFluid(BlockPos newpos) {
        BlockState state = this.field_145850_b.func_180495_p(newpos);
        ItemStack matcher = this.items.getStackInSlot(0);
        Block block = state.func_177230_c();
        if (matcher.func_190926_b()) {
            if (block instanceof FlowingFluidBlock || block instanceof IFluidBlock) {
                return !block.isAir(state, (IBlockReader)this.field_145850_b, newpos);
            }
            return false;
        }
        ItemStack stack = block.func_185473_a((IBlockReader)this.field_145850_b, newpos, state);
        Item matcherItem = matcher.func_77973_b();
        FluidStack matcherFluidStack = null;
        if (matcherItem instanceof BucketItem) {
            matcherFluidStack = new FluidBucketWrapper(matcher).getFluid();
            return this.checkFluid(block, matcherFluidStack, state, newpos);
        }
        return false;
    }

    private boolean checkFluid(Block block, FluidStack matcherFluidStack, BlockState state, BlockPos newpos) {
        if (matcherFluidStack == null) {
            return block.isAir(state, (IBlockReader)this.field_145850_b, newpos);
        }
        Fluid matcherFluid = matcherFluidStack.getFluid();
        if (matcherFluid == null) {
            return false;
        }
        Block matcherFluidBlock = matcherFluid.func_207188_f().func_206883_i().func_177230_c();
        if (matcherFluidBlock == null) {
            return false;
        }
        return matcherFluidBlock == block;
    }

    private boolean checkGrowthLevel(BlockPos newpos, LogicFacing facing, Direction dir) {
        int blockCount = this.areaType.getBlockCount();
        if (blockCount > 0) {
            Boolean x = this.checkGrowthLevelRow(newpos, dir, blockCount);
            if (x != null) {
                return x;
            }
        } else if (blockCount < 0) {
            Direction downSide = facing.getSide();
            Direction inputSide = facing.getInputSide();
            Direction rightSide = LogicSlabBlock.rotateLeft((Direction)downSide, (Direction)inputSide);
            Direction leftSide = LogicSlabBlock.rotateRight((Direction)downSide, (Direction)inputSide);
            Boolean x = this.checkGrowthLevelRow(newpos, dir, blockCount = -blockCount);
            if (x != null) {
                return x;
            }
            for (int i = 1; i <= (blockCount - 1) / 2; ++i) {
                BlockPos p = newpos.func_177967_a(leftSide, i);
                x = this.checkGrowthLevelRow(p, dir, blockCount);
                if (x != null) {
                    return x;
                }
                p = newpos.func_177967_a(rightSide, i);
                x = this.checkGrowthLevelRow(p, dir, blockCount);
                if (x == null) continue;
                return x;
            }
        }
        return this.groupType == GroupType.GROUP_ALL;
    }

    private Boolean checkGrowthLevelRow(BlockPos newpos, Direction dir, int blockCount) {
        for (int i = 0; i < blockCount; ++i) {
            boolean result = this.checkGrowthLevel(newpos);
            if (result && this.groupType == GroupType.GROUP_ONE) {
                return true;
            }
            if (!result && this.groupType == GroupType.GROUP_ALL) {
                return false;
            }
            newpos = newpos.func_177972_a(dir);
        }
        return null;
    }

    private boolean checkGrowthLevel(BlockPos newpos) {
        BlockState state = this.field_145850_b.func_180495_p(newpos);
        int pct = 0;
        for (IProperty property : state.func_206869_a()) {
            if (!"age".equals(property.func_177701_a())) continue;
            if (property.func_177699_b() != Integer.class) break;
            IProperty integerProperty = property;
            int age = (Integer)state.func_177229_b(integerProperty);
            int maxAge = (Integer)Collections.max(integerProperty.func_177700_c());
            pct = age * 100 / maxAge;
            break;
        }
        return pct >= this.number;
    }

    public void invalidateCache() {
        this.cachedBox = null;
    }

    private AxisAlignedBB getCachedBox(BlockPos pos1, LogicFacing facing, Direction dir) {
        if (this.cachedBox == null) {
            int n = this.areaType.getBlockCount();
            if (n > 0) {
                this.cachedBox = new AxisAlignedBB(pos1);
                if (n > 1) {
                    BlockPos pos2 = pos1.func_177967_a(dir, n - 1);
                    this.cachedBox = this.cachedBox.func_111270_a(new AxisAlignedBB(pos2));
                }
                this.cachedBox = this.cachedBox.func_72321_a(0.1, 0.1, 0.1);
            } else {
                BlockPos pos2;
                n = -n;
                this.cachedBox = new AxisAlignedBB(pos1);
                Direction downSide = facing.getSide();
                Direction inputSide = facing.getInputSide();
                Direction rightSide = LogicSlabBlock.rotateLeft((Direction)downSide, (Direction)inputSide);
                Direction leftSide = LogicSlabBlock.rotateRight((Direction)downSide, (Direction)inputSide);
                if (n > 1) {
                    pos2 = pos1.func_177967_a(dir, n - 1);
                    this.cachedBox = this.cachedBox.func_111270_a(new AxisAlignedBB(pos2));
                }
                pos2 = pos1.func_177967_a(leftSide, (n - 1) / 2);
                this.cachedBox = this.cachedBox.func_111270_a(new AxisAlignedBB(pos2));
                pos2 = pos1.func_177967_a(rightSide, (n - 1) / 2);
                this.cachedBox = this.cachedBox.func_111270_a(new AxisAlignedBB(pos2));
            }
        }
        return this.cachedBox;
    }

    private boolean checkEntities(BlockPos pos1, LogicFacing facing, Direction dir, Class<? extends Entity> clazz) {
        List entities = this.field_145850_b.func_217357_a(clazz, this.getCachedBox(pos1, facing, dir));
        return entities.size() >= this.number;
    }

    private boolean checkEntitiesHostile(BlockPos pos1, LogicFacing facing, Direction dir) {
        List entities = this.field_145850_b.func_217357_a(CreatureEntity.class, this.getCachedBox(pos1, facing, dir));
        int cnt = 0;
        for (Entity entity : entities) {
            if (!(entity instanceof IMob) || ++cnt < this.number) continue;
            return true;
        }
        return false;
    }

    private boolean checkEntitiesPassive(BlockPos pos1, LogicFacing facing, Direction dir) {
        List entities = this.field_145850_b.func_217357_a(CreatureEntity.class, this.getCachedBox(pos1, facing, dir));
        int cnt = 0;
        for (Entity entity : entities) {
            if (!(entity instanceof AnimalEntity) || entity instanceof IMob || ++cnt < this.number) continue;
            return true;
        }
        return false;
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerOutput = tagCompound.func_74767_n("rs") ? 15 : 0;
    }

    public void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.number = info.func_74762_e("number");
        this.sensorType = SensorType.values()[info.func_74771_c("sensor")];
        this.areaType = AreaType.values()[info.func_74771_c("area")];
        this.groupType = GroupType.values()[info.func_74771_c("group")];
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powerOutput > 0);
        return tagCompound;
    }

    public void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("number", this.number);
        info.func_74774_a("sensor", (byte)this.sensorType.ordinal());
        info.func_74774_a("area", (byte)this.areaType.ordinal());
        info.func_74774_a("group", (byte)this.groupType.ordinal());
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETAREA.equals(command)) {
            AreaType type = (AreaType)NamedEnum.getEnumByName((String)((String)params.get(ChoiceLabel.PARAM_CHOICE)), (NamedEnum[])AreaType.values());
            this.setAreaType(type);
            return true;
        }
        if (CMD_SETTYPE.equals(command)) {
            SensorType type = (SensorType)NamedEnum.getEnumByName((String)((String)params.get(ChoiceLabel.PARAM_CHOICE)), (NamedEnum[])SensorType.values());
            this.setSensorType(type);
            return true;
        }
        if (CMD_SETGROUP.equals(command)) {
            GroupType type = (GroupType)NamedEnum.getEnumByName((String)((String)params.get(ChoiceLabel.PARAM_CHOICE)), (NamedEnum[])GroupType.values());
            this.setGroupType(type);
            return true;
        }
        if (CMD_SETNUMBER.equals(command)) {
            int number;
            try {
                number = Integer.parseInt((String)params.get(TextField.PARAM_TEXT));
            }
            catch (NumberFormatException e) {
                number = 1;
            }
            this.setNumber(number);
            return true;
        }
        return false;
    }

    public void rotateBlock(Rotation axis) {
        this.invalidateCache();
    }

    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander((GenericTileEntity)this, (ContainerFactory)CONTAINER_FACTORY.get()){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }

            public boolean isItemInsertable(int slot, @Nonnull ItemStack stack) {
                return this.isItemValid(slot, stack);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.automationItemHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

