/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.apiimpl.teleportation;

import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.TeleportationTools;
import mcjty.rftoolsbase.api.teleportation.ITeleportationManager;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.TeleporterSetup;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class TeleportationManager
implements ITeleportationManager {
    public String getReceiverName(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == TeleporterSetup.MATTER_RECEIVER.get()) {
            MatterReceiverTileEntity te = (MatterReceiverTileEntity)world.func_175625_s(pos);
            return te.getName();
        }
        return null;
    }

    public boolean createReceiver(World world, BlockPos pos, String name, int power) {
        world.func_180501_a(pos, ((BaseBlock)TeleporterSetup.MATTER_RECEIVER.get()).func_176223_P(), 2);
        MatterReceiverTileEntity te = (MatterReceiverTileEntity)world.func_175625_s(pos);
        if (power == -1) {
            te.consumeEnergy(((Integer)TeleportConfiguration.RECEIVER_MAXENERGY.get()).intValue());
        } else {
            te.consumeEnergy(Math.min(power, (Integer)TeleportConfiguration.RECEIVER_MAXENERGY.get()));
        }
        te.setName(name);
        te.func_70296_d();
        this.registerReceiver(world, pos, name);
        return true;
    }

    private void registerReceiver(World world, BlockPos pos, String name) {
        TeleportDestinations destinations = TeleportDestinations.get(world);
        GlobalCoordinate gc = new GlobalCoordinate(pos, world.func_201675_m().func_186058_p());
        TeleportDestination destination = destinations.addDestination(gc);
        destination.setName(name);
        destinations.save();
    }

    public void teleportPlayer(PlayerEntity player, DimensionType dimension, BlockPos location) {
        TeleportationTools.teleportToDimension((PlayerEntity)player, (DimensionType)dimension, (double)location.func_177958_n(), (double)location.func_177956_o(), (double)location.func_177952_p());
    }

    public void removeReceiverDestinations(World world, DimensionType dim) {
        TeleportDestinations destinations = TeleportDestinations.get(world);
        destinations.removeDestinationsInDimension(dim);
        destinations.save();
    }
}

