/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiousshulkerboxes;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.capability.ICurio;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;
import top.theillusivec4.curiousshulkerboxes.client.EventHandlerClient;
import top.theillusivec4.curiousshulkerboxes.client.KeyRegistry;
import top.theillusivec4.curiousshulkerboxes.common.capability.CurioShulkerBox;
import top.theillusivec4.curiousshulkerboxes.common.integration.ironshulkerbox.CurioIronShulkerBox;
import top.theillusivec4.curiousshulkerboxes.common.integration.ironshulkerbox.IronShulkerBoxIntegration;
import top.theillusivec4.curiousshulkerboxes.common.network.NetworkHandler;

@Mod(value="curiousshulkerboxes")
public class CuriousShulkerBoxes {
    public static final String MODID = "curiousshulkerboxes";
    public static boolean isIronShulkerBoxesLoaded = false;

    public CuriousShulkerBoxes() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::enqueue);
        isIronShulkerBoxesLoaded = ModList.get().isLoaded("ironshulkerbox");
    }

    public static boolean isShulkerBox(Block block) {
        boolean isIronShulkerBox = isIronShulkerBoxesLoaded && IronShulkerBoxIntegration.isIronShulkerBox(block);
        return block instanceof ShulkerBoxBlock || isIronShulkerBox;
    }

    public static Optional<ImmutableTriple<String, Integer, ItemStack>> getCurioShulkerBox(LivingEntity livingEntity) {
        Predicate<ItemStack> shulkerBox = stack -> {
            Block block = ShulkerBoxBlock.func_149634_a((Item)stack.func_77973_b());
            return CuriousShulkerBoxes.isShulkerBox(block);
        };
        return CuriosAPI.getCurioEquipped(shulkerBox, (LivingEntity)livingEntity);
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        NetworkHandler.register();
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        KeyRegistry.register();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClient());
    }

    private void enqueue(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("back"));
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        Block block = ShulkerBoxBlock.func_149634_a((Item)stack.func_77973_b());
        if (CuriousShulkerBoxes.isShulkerBox(block)) {
            stack.func_190925_c("BlockEntityTag");
            final CurioShulkerBox curioShulkerBox = block instanceof ShulkerBoxBlock ? new CurioShulkerBox(stack) : new CurioIronShulkerBox(stack);
            evt.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){
                LazyOptional<ICurio> curio = LazyOptional.of(() -> curioShulkerBox);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.curio);
                }
            });
        }
    }
}

