/*
 * Decompiled with CFR 0.152.
 */
package me.dags.noise.combiner;

import me.dags.noise.Module;

public abstract class Combiner
implements Module {
    private final float min;
    private final float max;
    private final Module[] sources;

    public Combiner(Module ... sources) {
        float min = 0.0f;
        float max = 0.0f;
        if (sources.length > 0) {
            min = sources[0].minValue();
            max = sources[0].maxValue();
            for (int i = 1; i < sources.length; ++i) {
                Module next = sources[i];
                min = this.minTotal(min, next);
                max = this.maxTotal(max, next);
            }
        }
        this.min = min;
        this.max = max;
        this.sources = sources;
    }

    @Override
    public float getValue(float x, float y) {
        float result = 0.0f;
        if (this.sources.length > 0) {
            result = this.sources[0].getValue(x, y);
            for (int i = 1; i < this.sources.length; ++i) {
                Module module = this.sources[i];
                float value = module.getValue(x, y);
                result = this.combine(result, value);
            }
        }
        return result;
    }

    @Override
    public float minValue() {
        return this.min;
    }

    @Override
    public float maxValue() {
        return this.max;
    }

    protected abstract float minTotal(float var1, Module var2);

    protected abstract float maxTotal(float var1, Module var2);

    protected abstract float combine(float var1, float var2);
}

