/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.material;

import com.terraforged.api.material.WGTags;
import com.terraforged.api.material.layer.LayerManager;
import com.terraforged.mod.material.MaterialHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.tags.Tag;
import net.minecraftforge.registries.ForgeRegistries;

@Deprecated
public class Materials {
    private final Set<Block> stone = Materials.create(WGTags.STONE);
    private final Set<Block> dirt = Materials.create(WGTags.DIRT);
    private final Set<Block> clay = Materials.create(WGTags.CLAY);
    private final Set<Block> sediment = Materials.create(WGTags.SEDIMENT);
    private final Set<Block> erodible = Materials.create(WGTags.ERODIBLE);
    private final LayerManager layerManager = new LayerManager();

    public Materials() {
        Predicate<Block> filter = Materials.getTagFilter();
        for (Block block : ForgeRegistries.BLOCKS) {
            if (filter.test(block) || !MaterialHelper.isCube(block.func_176223_P())) continue;
            if (MaterialHelper.isStone(block)) {
                this.stone.add(block);
                continue;
            }
            if (MaterialHelper.isDirt(block)) {
                this.dirt.add(block);
                continue;
            }
            if (MaterialHelper.isClay(block)) {
                this.clay.add(block);
                continue;
            }
            if (!MaterialHelper.isSediment(block)) continue;
            this.sediment.add(block);
        }
        if (this.stone.isEmpty()) {
            this.stone.add(Blocks.field_150348_b);
        }
    }

    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public boolean isStone(Block block) {
        return this.stone.contains(block);
    }

    public boolean isEarth(Block block) {
        return this.dirt.contains(block);
    }

    public boolean isClay(Block block) {
        return this.clay.contains(block);
    }

    public boolean isSediment(Block block) {
        return this.sediment.contains(block);
    }

    public boolean isErodible(Block block) {
        return this.erodible.contains(block);
    }

    private static Set<Block> create(Tag<Block> tag) {
        return new HashSet<Block>(tag.func_199885_a());
    }

    private static Predicate<Block> getTagFilter() {
        HashSet<String> namespaces = new HashSet<String>();
        Materials.collectNamespace(namespaces, WGTags.STONE.func_199885_a());
        Materials.collectNamespace(namespaces, WGTags.DIRT.func_199885_a());
        Materials.collectNamespace(namespaces, WGTags.DIRT.func_199885_a());
        Materials.collectNamespace(namespaces, WGTags.SEDIMENT.func_199885_a());
        return b -> namespaces.contains(MaterialHelper.getNamespace(b));
    }

    private static void collectNamespace(Set<String> set, Collection<Block> blocks) {
        for (Block block : blocks) {
            set.add(MaterialHelper.getNamespace(block));
        }
    }
}

