/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.gui.page;

import com.terraforged.core.settings.Settings;
import com.terraforged.mod.gui.OverlayScreen;
import com.terraforged.mod.gui.page.BasePage;
import com.terraforged.mod.gui.page.Page;
import com.terraforged.mod.gui.preview.PreviewPage;
import com.terraforged.mod.util.nbt.NBTHelper;
import net.minecraft.nbt.CompoundNBT;

public class TerrainPage
extends BasePage {
    private final Settings settings;
    private final PreviewPage preview;
    private final CompoundNBT terrainSettings;

    public TerrainPage(Settings settings, PreviewPage preview) {
        this.settings = settings;
        this.preview = preview;
        this.terrainSettings = NBTHelper.serialize(settings.terrain);
    }

    @Override
    public String getTitle() {
        return "Terrain Settings";
    }

    @Override
    public void save() {
        NBTHelper.deserialize(this.terrainSettings, this.settings.terrain);
    }

    @Override
    public void init(OverlayScreen parent) {
        Page.Column center = this.getColumn(0);
        center.scrollPane.setScrollAmount(0.0);
        this.addElements(0, 0, center, this.terrainSettings, true, center.scrollPane::addButton, this::update);
    }

    @Override
    protected void update() {
        super.update();
        this.preview.apply(settings -> NBTHelper.deserialize(this.terrainSettings, settings.terrain));
    }
}

