/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.map;

import com.google.gson.JsonElement;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.world.biome.BiomeType;
import com.terraforged.core.world.terrain.Terrain;
import java.util.List;
import java.util.Set;
import net.minecraft.world.biome.Biome;

public interface BiomeMap {
    public Biome getBeach(float var1, float var2, float var3);

    public Biome getRiver(float var1, float var2, float var3);

    public Biome getWetland(float var1, float var2, float var3);

    public Biome getOcean(float var1, float var2, float var3);

    public Biome getDeepOcean(float var1, float var2, float var3);

    public Biome getBiome(BiomeType var1, float var2, float var3, float var4);

    default public Biome getBiome(Cell<Terrain> cell) {
        return this.getBiome(cell.biomeType, cell.temperature, cell.moisture, cell.biome);
    }

    public List<Biome> getAllBiomes(BiomeType var1);

    public Set<Biome> getBiomes(BiomeType var1);

    public Set<Biome> getRivers(Biome.TempCategory var1);

    public Set<Biome> getOceanBiomes(Biome.TempCategory var1);

    public Set<Biome> getDeepOceanBiomes(Biome.TempCategory var1);

    public JsonElement toJson();

    public static Biome getBiome(Biome biome) {
        return (Biome)biome.delegate.get();
    }

    public static interface Builder {
        public Builder addBeach(Biome var1, int var2);

        public Builder addRiver(Biome var1, int var2);

        public Builder addWetland(Biome var1, int var2);

        public Builder addOcean(Biome var1, int var2);

        public Builder addBiome(BiomeType var1, Biome var2, int var3);

        public BiomeMap build();
    }
}

