/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.climate;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.world.GeneratorContext;
import com.terraforged.core.world.climate.ClimateModule;
import com.terraforged.core.world.terrain.Terrain;
import me.dags.noise.Module;
import me.dags.noise.Source;
import me.dags.noise.source.Rand;

public class Climate {
    private final float seaLevel;
    private final float lowerHeight;
    private final float midHeight = 0.45f;
    private final float upperHeight = 0.75f;
    private final float moistureModifier = 0.1f;
    private final float temperatureModifier = 0.05f;
    private final Rand rand;
    private final Module treeLine;
    private final Module offsetX;
    private final Module offsetY;
    private final ClimateModule biomeNoise;

    public Climate(GeneratorContext context) {
        this.biomeNoise = new ClimateModule(context.seed, context.settings);
        this.treeLine = Source.perlin(context.seed.next(), context.settings.generator.biome.biomeSize * 2, 1).scale(context.levels.scale(25)).bias(context.levels.ground(40)).clamp(0.0, 1.0);
        this.rand = new Rand(Source.builder().seed(context.seed.next()));
        this.offsetX = context.settings.generator.biomeEdgeNoise.build(context.seed.next());
        this.offsetY = context.settings.generator.biomeEdgeNoise.build(context.seed.next());
        this.seaLevel = context.levels.water;
        this.lowerHeight = context.levels.ground;
    }

    public Rand getRand() {
        return this.rand;
    }

    public float getOffsetX(float x, float z, int distance) {
        return this.offsetX.getValue(x, z) * (float)distance;
    }

    public float getOffsetZ(float x, float z, int distance) {
        return this.offsetY.getValue(x, z) * (float)distance;
    }

    public float getTreeLine(float x, float z) {
        return this.treeLine.getValue(x, z);
    }

    public void apply(Cell<Terrain> cell, float x, float z, boolean mask) {
        this.biomeNoise.apply(cell, x, z, mask);
        this.modifyTemp(cell, x, z);
    }

    private void modifyTemp(Cell<Terrain> cell, float x, float z) {
        float height = cell.value;
        if (height > 0.75f) {
            cell.temperature = Math.max(0.0f, cell.temperature - 0.05f);
            return;
        }
        if (height > 0.45f) {
            float delta = (height - 0.45f) / 0.3f;
            cell.temperature = Math.max(0.0f, cell.temperature - delta * 0.05f);
            return;
        }
        if ((height = Math.max(this.lowerHeight, height)) >= this.lowerHeight) {
            float delta = 1.0f - (height - this.lowerHeight) / (0.45f - this.lowerHeight);
            cell.temperature = Math.min(1.0f, cell.temperature + delta * 0.05f);
        }
    }
}

