/*
 * Decompiled with CFR 0.152.
 */
package shadows.click.net;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import shadows.click.block.TileAutoClick;
import shadows.click.block.gui.GuiAutoClick;
import shadows.placebo.util.NetworkUtils;

public class MessageUpdateGui
extends NetworkUtils.MessageProvider<MessageUpdateGui> {
    Type t;
    int power;
    int speedIdx;
    boolean right;
    boolean sneak;

    public MessageUpdateGui(Type t, int power, TileAutoClick te) {
        if (t == Type.POWER) {
            this.power = power;
        } else {
            this.power = te.getPower();
            this.speedIdx = te.getSpeedIndex();
            this.right = te.isRightClicking();
            this.sneak = te.isSneaking();
        }
        this.t = t;
    }

    public MessageUpdateGui(TileAutoClick te) {
        this(Type.SYNC, -1, te);
    }

    public MessageUpdateGui(int power) {
        this(Type.POWER, power, null);
    }

    public MessageUpdateGui() {
    }

    public MessageUpdateGui read(PacketBuffer buf) {
        MessageUpdateGui msg = new MessageUpdateGui();
        msg.t = Type.values()[buf.readByte()];
        msg.power = buf.readInt();
        if (msg.t == Type.SYNC) {
            msg.speedIdx = buf.readInt();
            msg.right = buf.readBoolean();
            msg.sneak = buf.readBoolean();
        }
        return msg;
    }

    public void write(MessageUpdateGui msg, PacketBuffer buf) {
        buf.writeByte(msg.t.ordinal());
        buf.writeInt(msg.power);
        if (msg.t == Type.SYNC) {
            buf.writeInt(msg.speedIdx);
            buf.writeBoolean(msg.right);
            buf.writeBoolean(msg.sneak);
        }
    }

    public void handle(MessageUpdateGui msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkUtils.handlePacket(() -> () -> {
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiAutoClick) {
                if (msg.t == Type.POWER) {
                    ((GuiAutoClick)Minecraft.func_71410_x().field_71462_r).getTile().setPower(msg.power);
                } else {
                    ((GuiAutoClick)Minecraft.func_71410_x().field_71462_r).updateTile(msg.speedIdx, msg.sneak, msg.right, msg.power);
                }
            }
        }, (NetworkEvent.Context)ctx.get());
    }

    public Class<MessageUpdateGui> getMsgClass() {
        return MessageUpdateGui.class;
    }

    public static enum Type {
        POWER,
        SYNC;

    }
}

