/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item.tool;

import com.blakebr0.cucumber.item.tool.BaseAxeItem;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import com.blakebr0.mysticalagriculture.api.tinkering.IAugment;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import com.blakebr0.mysticalagriculture.api.util.AugmentUtils;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EssenceAxeItem
extends BaseAxeItem
implements ITinkerable {
    private static final EnumSet<AugmentType> TYPES = EnumSet.of(AugmentType.TOOL, AugmentType.AXE);
    private final int tinkerableTier;
    private final int slots;

    public EssenceAxeItem(IItemTier tier, int tinkerableTier, int slots, Function<Item.Properties, Item.Properties> properties) {
        super(tier, properties);
        this.tinkerableTier = tinkerableTier;
        this.slots = slots;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        List<IAugment> augments = AugmentUtils.getAugments(context.func_195996_i());
        boolean success = false;
        for (IAugment augment : augments) {
            if (!augment.onItemUse(context)) continue;
            success = true;
        }
        if (success) {
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        List<IAugment> augments = AugmentUtils.getAugments(stack);
        boolean success = false;
        for (IAugment augment : augments) {
            if (!augment.onRightClick(stack, world, player, hand)) continue;
            success = true;
        }
        if (success) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        List<IAugment> augments = AugmentUtils.getAugments(stack);
        boolean success = false;
        for (IAugment augment : augments) {
            if (!augment.onRightClickEntity(stack, player, target, hand)) continue;
            success = true;
        }
        return success;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        List<IAugment> augments = AugmentUtils.getAugments(stack);
        boolean success = false;
        for (IAugment augment : augments) {
            if (!augment.onHitEntity(stack, target, attacker)) continue;
            success = true;
        }
        return success;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        super.func_179218_a(stack, world, state, pos, entity);
        List<IAugment> augments = AugmentUtils.getAugments(stack);
        boolean success = false;
        for (IAugment augment : augments) {
            if (!augment.onBlockDestroyed(stack, world, state, pos, entity)) continue;
            success = true;
        }
        return success;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        List<IAugment> augments = AugmentUtils.getAugments(stack);
        boolean success = false;
        for (IAugment augment : augments) {
            if (!augment.onBlockStartBreak(stack, pos, player)) continue;
            success = true;
        }
        return success;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        AugmentUtils.getAugments(stack).forEach(a -> a.onInventoryTick(stack, world, entity, slot, isSelected));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(ModTooltips.getTooltipForTier(this.tinkerableTier));
        AugmentUtils.getAugments(stack).forEach(a -> tooltip.add(a.getDisplayName().func_211708_a(TextFormatting.GRAY)));
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            modifiers.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.field_77865_bY, AttributeModifier.Operation.ADDITION));
            modifiers.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.field_185065_c, AttributeModifier.Operation.ADDITION));
            AugmentUtils.getAugments(stack).forEach(arg_0 -> EssenceAxeItem.lambda$getAttributeModifiers$2((Multimap)modifiers, slot, stack, arg_0));
        }
        return modifiers;
    }

    @Override
    public int getAugmentSlots() {
        return this.slots;
    }

    @Override
    public EnumSet<AugmentType> getAugmentTypes() {
        return TYPES;
    }

    @Override
    public int getTinkerableTier() {
        return this.tinkerableTier;
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$2(Multimap modifiers, EquipmentSlotType slot, ItemStack stack, IAugment a) {
        a.addToolAttributeModifiers((Multimap<String, AttributeModifier>)modifiers, slot, stack);
    }
}

