/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.modcompatibility;

import java.util.concurrent.Callable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.telepathicgrunt.bumblezone.Bumblezone;
import net.telepathicgrunt.bumblezone.modcompatibility.AbnormalsCoreCompat;
import net.telepathicgrunt.bumblezone.modcompatibility.BeesourcefulCompat;
import net.telepathicgrunt.bumblezone.modcompatibility.BuzzierBeesCompat;
import net.telepathicgrunt.bumblezone.modcompatibility.PotionOfBeesCompat;
import net.telepathicgrunt.bumblezone.modcompatibility.ProductiveBeesCompat;
import org.apache.logging.log4j.Level;
import org.apache.maven.artifact.versioning.ArtifactVersion;

@Mod.EventBusSubscriber(modid="the_bumblezone", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModChecking {
    public static boolean buzzierBeesPresent = false;
    public static boolean AbnormalsCorePresent = false;
    public static boolean potionOfBeesPresent = false;
    public static boolean beesourcefulPresent = false;
    public static boolean productiveBeesPresent = false;

    public static void setupModCompat() {
        String currentModID = "";
        try {
            currentModID = "buzzierbees";
            if (ModList.get().isLoaded(currentModID)) {
                ArtifactVersion bbVersion = ((ModContainer)ModList.get().getModContainerById(currentModID).get()).getModInfo().getVersion();
                int majorVersion = bbVersion.getMajorVersion();
                int minorVersion = bbVersion.getMinorVersion();
                if (majorVersion == 1 && minorVersion == 4) {
                    ModChecking.runSetupForMod(() -> () -> BuzzierBeesCompat.setupBuzzierBees());
                    Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
                    Bumblezone.LOGGER.log(Level.INFO, " ");
                    Bumblezone.LOGGER.log(Level.INFO, "BUMBLEZONE: You're using a version of Buzzier Bees that is know to freeze worlds! Please update Buzzier Bees to v1.5 or greater!");
                    Bumblezone.LOGGER.log(Level.INFO, " ");
                    Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
                }
                if (majorVersion == 1 && minorVersion >= 5 || majorVersion > 1 || bbVersion.toString().equals("v1.5.0")) {
                    ModChecking.runSetupForMod(() -> () -> BuzzierBeesCompat.setupBuzzierBees());
                    currentModID = "abnormals_core";
                    if (buzzierBeesPresent && ModList.get().isLoaded(currentModID)) {
                        ModChecking.runSetupForMod(() -> () -> AbnormalsCoreCompat.setupAbnormalsCore());
                    }
                }
            }
        }
        catch (Exception e) {
            ModChecking.printErrorToLogs(currentModID);
            e.printStackTrace();
        }
        try {
            currentModID = "beesourceful";
            if (ModList.get().isLoaded(currentModID)) {
                int majorVersion = ((ModContainer)ModList.get().getModContainerById(currentModID).get()).getModInfo().getVersion().getMajorVersion();
                int minorVersion = ((ModContainer)ModList.get().getModContainerById(currentModID).get()).getModInfo().getVersion().getMinorVersion();
                if (majorVersion == 1 && minorVersion >= 1 || majorVersion > 1) {
                    ModChecking.runSetupForMod(() -> () -> BeesourcefulCompat.setupBeesourceful());
                }
            }
        }
        catch (Exception e) {
            ModChecking.printErrorToLogs(currentModID);
            e.printStackTrace();
        }
        try {
            currentModID = "potionofbees";
            if (ModList.get().isLoaded(currentModID)) {
                ModChecking.runSetupForMod(() -> () -> PotionOfBeesCompat.setupPotionOfBees());
            }
        }
        catch (Exception e) {
            ModChecking.printErrorToLogs(currentModID);
            e.printStackTrace();
        }
        try {
            currentModID = "productivebees";
            if (ModList.get().isLoaded(currentModID)) {
                ModChecking.runSetupForMod(() -> () -> ProductiveBeesCompat.setupProductiveBees());
            }
        }
        catch (Exception e) {
            ModChecking.printErrorToLogs(currentModID);
            e.printStackTrace();
        }
    }

    private static void printErrorToLogs(String currentModID) {
        Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
        Bumblezone.LOGGER.log(Level.INFO, " ");
        Bumblezone.LOGGER.log(Level.INFO, "ERROR: Something broke when trying to add mod compatibility with" + currentModID + ". Please let The Bumblezone developer know about this!");
        Bumblezone.LOGGER.log(Level.INFO, " ");
        Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
    }

    public static void runSetupForMod(Callable<Runnable> toRun) throws Exception {
        toRun.call().run();
    }

    @Mod.EventBusSubscriber(modid="the_bumblezone")
    private static class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent
        public static void MobSpawnEvent(PlayerEvent.PlayerLoggedInEvent event) {
            if (buzzierBeesPresent) {
                ArtifactVersion bbVersion = ((ModContainer)ModList.get().getModContainerById("buzzierbees").get()).getModInfo().getVersion();
                int majorVersion = bbVersion.getMajorVersion();
                int minorVersion = bbVersion.getMinorVersion();
                if (majorVersion == 1 && minorVersion <= 4) {
                    ((PlayerEntity)event.getEntity()).func_145747_a((ITextComponent)new StringTextComponent("\u00a7cBumblezone Warning: The version of Buzzier Bees you have on is too old and can cause the game to freeze with Bumblezone. Please update Buzzier Bees to v1.5 or greater!"));
                }
            }
        }
    }
}

