/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.misc;

import de.ellpeck.prettypipes.misc.FilterSlot;
import de.ellpeck.prettypipes.misc.ItemEqualityType;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import de.ellpeck.prettypipes.pipe.modules.FilterModifierModule;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ItemFilter
extends ItemStackHandler {
    private final ItemStack stack;
    private final PipeTileEntity pipe;
    public boolean isWhitelist;
    public boolean canPopulateFromInventories;
    public boolean canModifyWhitelist = true;

    public ItemFilter(int size, ItemStack stack, PipeTileEntity pipe) {
        super(size);
        this.stack = stack;
        this.pipe = pipe;
        if (stack.func_77942_o()) {
            this.deserializeNBT(stack.func_77978_p().func_74775_l("filter"));
        }
    }

    public List<Slot> getSlots(int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < this.getSlots(); ++i) {
            slots.add((Slot)new FilterSlot((IItemHandler)this, i, x + i % 9 * 18, y + i / 9 * 18));
        }
        return slots;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Widget> getButtons(final Screen gui, int x, int y) {
        ArrayList<Widget> buttons = new ArrayList<Widget>();
        if (this.canModifyWhitelist) {
            Supplier<String> whitelistText = () -> I18n.func_135052_a((String)("info.prettypipes." + (this.isWhitelist ? "whitelist" : "blacklist")), (Object[])new Object[0]);
            buttons.add((Widget)new Button(x, y, 70, 20, whitelistText.get(), button -> {
                PacketButton.sendAndExecute(this.pipe.func_174877_v(), PacketButton.ButtonResult.FILTER_CHANGE, 0);
                button.setMessage((String)whitelistText.get());
            }));
        }
        if (this.canPopulateFromInventories) {
            buttons.add((Widget)new Button(x + 72, y, 70, 20, I18n.func_135052_a((String)"info.prettypipes.populate", (Object[])new Object[0]), button -> PacketButton.sendAndExecute(this.pipe.func_174877_v(), PacketButton.ButtonResult.FILTER_CHANGE, 1)){

                public void renderToolTip(int x, int y) {
                    gui.renderTooltip(TextFormatting.GRAY + I18n.func_135052_a((String)"info.prettypipes.populate.description", (Object[])new Object[0]), x, y);
                }
            });
        }
        return buttons;
    }

    public void onButtonPacket(int id) {
        if (id == 0 && this.canModifyWhitelist) {
            this.isWhitelist = !this.isWhitelist;
        } else if (id == 1 && this.canPopulateFromInventories) {
            for (Direction direction : Direction.values()) {
                IItemHandler handler = this.pipe.getItemHandler(direction, null);
                if (handler == null) continue;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.func_190926_b() || this.isFiltered(stack)) continue;
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190920_e(1);
                    ItemHandlerHelper.insertItem((IItemHandler)this, (ItemStack)copy, (boolean)false);
                }
            }
        }
        this.save();
    }

    public boolean isAllowed(ItemStack stack) {
        return this.isFiltered(stack) == this.isWhitelist;
    }

    private boolean isFiltered(ItemStack stack) {
        ItemEqualityType[] types = this.getEqualityTypes();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack filter = this.getStackInSlot(i);
            if (filter.func_190926_b() || !ItemEqualityType.compareItems(stack, filter, types)) continue;
            return true;
        }
        return false;
    }

    public ItemEqualityType[] getEqualityTypes() {
        return (ItemEqualityType[])this.pipe.streamModules().map(Pair::getRight).filter(m -> m instanceof FilterModifierModule).map(m -> ((FilterModifierModule)m).type).toArray(ItemEqualityType[]::new);
    }

    public void save() {
        this.stack.func_196082_o().func_218657_a("filter", (INBT)this.serializeNBT());
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_74757_a("whitelist", this.isWhitelist);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.isWhitelist = nbt.func_74767_n("whitelist");
    }

    public static interface IFilteredContainer {
        public ItemFilter getFilter();
    }
}

