/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.xnet.IXNet;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectable;
import mcjty.rftoolsbase.api.xnet.channels.IConsumerProvider;
import mcjty.rftoolsbase.api.xnet.net.IWorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.world.World;

public class XNetApi
implements IXNet {
    private final Map<String, IChannelType> channels = new HashMap<String, IChannelType>();
    private final List<IConnectable> connectables = new ArrayList<IConnectable>();
    private final List<IConsumerProvider> consumerProviders = new ArrayList<IConsumerProvider>();

    public void registerChannelType(IChannelType type) {
        this.channels.put(type.getID(), type);
    }

    public void registerConnectable(@Nonnull IConnectable connectable) {
        this.connectables.add(connectable);
    }

    public void registerConsumerProvider(@Nonnull IConsumerProvider consumerProvider) {
        this.consumerProviders.add(consumerProvider);
    }

    public List<IConsumerProvider> getConsumerProviders() {
        return this.consumerProviders;
    }

    @Nullable
    public IChannelType findType(@Nonnull String id) {
        return this.channels.get(id);
    }

    public Map<String, IChannelType> getChannels() {
        return this.channels;
    }

    public List<IConnectable> getConnectables() {
        return this.connectables;
    }

    public IWorldBlob getWorldBlob(World world) {
        return XNetBlobData.get(world).getWorldBlob(world);
    }
}

