/*
 * Decompiled with CFR 0.152.
 */
package koala.fishingreal.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import koala.fishingreal.FishingReal;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class JsonUtils {
    public static ItemStack deserializeItemStack(JsonObject object) {
        String id = object.get("item").getAsString();
        int count = object.has("count") ? object.get("count").getAsInt() : 1;
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
        return new ItemStack((IItemProvider)item, count);
    }

    public static JsonObject serializeItemStack(ItemStack stack) {
        JsonObject object = new JsonObject();
        object.addProperty("item", stack.func_77973_b().getRegistryName().toString());
        if (stack.func_190916_E() > 1) {
            object.addProperty("count", (Number)stack.func_190916_E());
        }
        return object;
    }

    public static CompoundNBT deserializeCompoundNBT(JsonObject object) {
        try {
            return JsonToNBT.func_180713_a((String)object.toString());
        }
        catch (CommandSyntaxException e) {
            FishingReal.LOGGER.error("Parsing error loading json as NBT {}", (Object)object.toString());
            return new CompoundNBT();
        }
    }

    public static JsonObject serializeCompoundNBT(CompoundNBT nbt) {
        nbt = nbt.func_74737_b();
        JsonObject object = new JsonObject();
        object.addProperty("id", nbt.func_74779_i("id"));
        nbt.func_82580_o("id");
        if (nbt.func_186856_d() > 0) {
            object.add("nbt", (JsonElement)new Gson().fromJson(nbt.toString(), JsonObject.class));
        }
        return object;
    }
}

