/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public interface ISerializableTanks {
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks();

    default public void deserializeTanks(CompoundNBT tag) {
        for (Map.Entry<String, FluidTank> entry : this.getSerializableTanks().entrySet()) {
            entry.getValue().readFromNBT(tag.func_74775_l(entry.getKey()));
        }
    }

    default public CompoundNBT serializeTanks() {
        CompoundNBT tag = new CompoundNBT();
        for (Map.Entry<String, FluidTank> entry : this.getSerializableTanks().entrySet()) {
            if (entry.getValue().getFluid().isEmpty()) continue;
            tag.func_218657_a(entry.getKey(), (INBT)entry.getValue().writeToNBT(new CompoundNBT()));
        }
        return tag;
    }

    public static void serializeTank(FluidTank tank, ItemStack stack, String tagName) {
        CompoundNBT tag = stack.func_190925_c("BlockEntityTag");
        CompoundNBT subTag = tag.func_74775_l("SavedTanks");
        if (!tank.getFluid().isEmpty()) {
            subTag.func_218657_a(tagName, (INBT)tank.writeToNBT(new CompoundNBT()));
        } else {
            subTag.func_82580_o(tagName);
        }
        if (!subTag.isEmpty()) {
            tag.func_218657_a("SavedTanks", (INBT)subTag);
        } else {
            tag.func_82580_o("SavedTanks");
        }
    }

    public static FluidTank deserializeTank(ItemStack stack, String tagName, int capacity) {
        CompoundNBT tag = stack.func_179543_a("BlockEntityTag");
        if (tag != null && tag.func_74764_b("SavedTanks")) {
            FluidTank tank = new FluidTank(capacity);
            CompoundNBT subTag = tag.func_74775_l("SavedTanks");
            return tank.readFromNBT(subTag.func_74775_l(tagName));
        }
        return null;
    }
}

