/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.sensor.pollSensors;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.universal_sensor.IBlockAndCoordinatePollSensor;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.math.NumberUtils;

public class BlockHeatSensor
implements IBlockAndCoordinatePollSensor {
    @Override
    public String getSensorPath() {
        return "Block/Heat";
    }

    @Override
    public Set<EnumUpgrade> getRequiredUpgrades() {
        return ImmutableSet.of((Object)((Object)EnumUpgrade.BLOCK_TRACKER));
    }

    @Override
    public int getPollFrequency() {
        return 20;
    }

    @Override
    public boolean needsTextBox() {
        return true;
    }

    @Override
    public List<String> getDescription() {
        ArrayList<String> text = new ArrayList<String>();
        text.add(TextFormatting.BLACK + I18n.func_135052_a((String)"gui.universalSensor.desc.heatSensor", (Object[])new Object[0]));
        return text;
    }

    @Override
    public int getRedstoneValue(World world, BlockPos pos, int sensorRange, String textBoxText, Set<BlockPos> positions) {
        double temperature = Double.MIN_VALUE;
        for (BlockPos p : positions) {
            TileEntity te = world.func_175625_s(p);
            for (Direction d : Direction.field_199792_n) {
                temperature = Math.max(temperature, (Double)te.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, d).map(IHeatExchangerLogic::getTemperature).orElse((Object)0.0));
            }
        }
        return NumberUtils.isCreatable((String)textBoxText) ? (temperature - 273.0 > (double)NumberUtils.toInt((String)textBoxText) ? 15 : 0) : HeatUtil.getComparatorOutput((int)temperature);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawAdditionalInfo(FontRenderer fontRenderer) {
        fontRenderer.func_211126_b("Temperature", 70.0f, 48.0f, 0x404040);
    }
}

