/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockCondition;
import me.desht.pneumaticcraft.common.ai.DroneAIDig;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCondition;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class ProgWidgetBlockCondition
extends ProgWidgetCondition {
    public boolean checkingForAir;
    public boolean checkingForLiquids;

    public ProgWidgetBlockCondition() {
        super(ModProgWidgets.CONDITION_BLOCK);
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.AREA, ModProgWidgets.ITEM_FILTER, ModProgWidgets.TEXT);
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDroneBase drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(BlockPos pos) {
                if (ProgWidgetBlockCondition.this.checkingForAir && this.drone.world().func_175623_d(pos)) {
                    return true;
                }
                if (ProgWidgetBlockCondition.this.checkingForLiquids && PneumaticCraftUtils.isBlockLiquid(this.drone.world().func_180495_p(pos).func_177230_c())) {
                    return true;
                }
                if (!ProgWidgetBlockCondition.this.checkingForAir && !ProgWidgetBlockCondition.this.checkingForLiquids || ProgWidgetBlockCondition.this.getConnectedParameters()[1] != null) {
                    return DroneAIDig.isBlockValidForFilter((IBlockReader)this.drone.world(), pos, this.drone, this.progWidget);
                }
                return false;
            }
        };
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_BLOCK;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("checkingForAir", this.checkingForAir);
        tag.func_74757_a("checkingForLiquids", this.checkingForLiquids);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.checkingForAir = tag.func_74767_n("checkingForAir");
        this.checkingForLiquids = tag.func_74767_n("checkingForLiquids");
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.checkingForAir);
        buf.writeBoolean(this.checkingForLiquids);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.checkingForAir = buf.readBoolean();
        this.checkingForLiquids = buf.readBoolean();
    }
}

