/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.ArmorMessage;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSendArmorHUDMessage {
    private String title;
    private int duration;
    private int color;
    private List<String> args;

    public PacketSendArmorHUDMessage() {
    }

    public PacketSendArmorHUDMessage(String title, int duration, String ... args) {
        this(title, duration, 0x7000FF00, new String[0]);
    }

    public PacketSendArmorHUDMessage(String title, int duration, int color, String ... args) {
        this.title = title;
        this.duration = duration;
        this.color = color;
        this.args = Arrays.asList(args);
    }

    PacketSendArmorHUDMessage(PacketBuffer buffer) {
        this.title = buffer.func_218666_n();
        this.duration = buffer.readInt();
        this.color = buffer.readInt();
        this.args = new ArrayList<String>();
        int n = buffer.readByte();
        for (int i = 0; i < n; ++i) {
            this.args.add(buffer.func_218666_n());
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.title);
        buf.writeInt(this.duration);
        buf.writeInt(this.color);
        buf.writeByte(this.args.size());
        this.args.forEach(arg_0 -> ((PacketBuffer)buf).func_180714_a(arg_0));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            String msg = I18n.func_135052_a((String)this.title, (Object[])this.args.toArray());
            HUDHandler.instance().addMessage(new ArmorMessage(msg, Collections.emptyList(), this.duration, this.color));
        });
        ctx.get().setPacketHandled(true);
    }
}

