/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.network.FilteredSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.SyncedField;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class NetworkUtils {
    public static List<SyncedField> getSyncedFields(Object syncable, Class<? extends Annotation> searchedAnnotation) {
        ArrayList<SyncedField> syncedFields = new ArrayList<SyncedField>();
        for (Class<?> examinedClass = syncable.getClass(); examinedClass != null; examinedClass = examinedClass.getSuperclass()) {
            for (Field field2 : examinedClass.getDeclaredFields()) {
                if (field2.getAnnotation(searchedAnnotation) == null) continue;
                syncedFields.addAll(NetworkUtils.getSyncedFieldsForField(field2, syncable, searchedAnnotation));
            }
        }
        syncedFields.forEach(field -> field.setAnnotation(searchedAnnotation));
        return syncedFields;
    }

    /*
     * WARNING - void declaration
     */
    private static List<SyncedField> getSyncedFieldsForField(Field field, Object te, Class<? extends Annotation> searchedAnnotation) {
        boolean isLazy = field.getAnnotation(LazySynced.class) != null;
        ArrayList<SyncedField> syncedFields = new ArrayList<SyncedField>();
        SyncedField syncedField = NetworkUtils.getSyncedFieldForField(field, te);
        if (syncedField != null) {
            syncedFields.add(syncedField.setLazy(isLazy));
            return syncedFields;
        }
        try {
            Object[] array;
            int filteredIndex = field.getAnnotation(FilteredSynced.class) != null ? field.getAnnotation(FilteredSynced.class).index() : -1;
            field.setAccessible(true);
            Object o = field.get(te);
            if (o instanceof int[]) {
                int[] array2 = (int[])o;
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedInt(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    void var9_19;
                    boolean bl = false;
                    while (var9_19 < array2.length) {
                        syncedFields.add(new SyncedField.SyncedInt(te, field).setArrayIndex((int)var9_19).setLazy(isLazy));
                        ++var9_19;
                    }
                }
                return syncedFields;
            }
            if (o instanceof float[]) {
                float[] array3 = (float[])o;
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedFloat(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    void var9_21;
                    boolean bl = false;
                    while (var9_21 < array3.length) {
                        syncedFields.add(new SyncedField.SyncedFloat(te, field).setArrayIndex((int)var9_21).setLazy(isLazy));
                        ++var9_21;
                    }
                }
                return syncedFields;
            }
            if (o instanceof double[]) {
                double[] array4 = (double[])o;
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedDouble(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    void var9_23;
                    boolean bl = false;
                    while (var9_23 < array4.length) {
                        syncedFields.add(new SyncedField.SyncedDouble(te, field).setArrayIndex((int)var9_23).setLazy(isLazy));
                        ++var9_23;
                    }
                }
                return syncedFields;
            }
            if (o instanceof boolean[]) {
                boolean[] array5 = (boolean[])o;
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedBoolean(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    void var9_25;
                    boolean bl = false;
                    while (var9_25 < array5.length) {
                        syncedFields.add(new SyncedField.SyncedBoolean(te, field).setArrayIndex((int)var9_25).setLazy(isLazy));
                        ++var9_25;
                    }
                }
                return syncedFields;
            }
            if (o instanceof String[]) {
                String[] array6 = (String[])o;
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedString(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    void var9_27;
                    boolean bl = false;
                    while (var9_27 < array6.length) {
                        syncedFields.add(new SyncedField.SyncedString(te, field).setArrayIndex((int)var9_27).setLazy(isLazy));
                        ++var9_27;
                    }
                }
                return syncedFields;
            }
            if (o.getClass().isArray() && o.getClass().getComponentType().isEnum()) {
                Object[] enumArray = (Object[])o;
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedEnum(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    void var9_29;
                    boolean bl = false;
                    while (var9_29 < enumArray.length) {
                        syncedFields.add(new SyncedField.SyncedEnum(te, field).setArrayIndex((int)var9_29).setLazy(isLazy));
                        ++var9_29;
                    }
                }
                return syncedFields;
            }
            if (o instanceof ItemStack[]) {
                ItemStack[] array7 = (ItemStack[])o;
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedItemStack(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    void var9_31;
                    boolean bl = false;
                    while (var9_31 < array7.length) {
                        syncedFields.add(new SyncedField.SyncedItemStack(te, field).setArrayIndex((int)var9_31).setLazy(isLazy));
                        ++var9_31;
                    }
                }
                return syncedFields;
            }
            if (o instanceof FluidStack[]) {
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedFluidStack(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    void var9_33;
                    FluidStack[] array8 = (FluidStack[])o;
                    boolean bl = false;
                    while (var9_33 < array8.length) {
                        syncedFields.add(new SyncedField.SyncedFluidStack(te, field).setArrayIndex((int)var9_33).setLazy(isLazy));
                        ++var9_33;
                    }
                }
                return syncedFields;
            }
            if (o instanceof ItemStackHandler[]) {
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedItemStack(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    void var9_35;
                    array = (ItemStackHandler[])o;
                    boolean bl = false;
                    while (var9_35 < array.length) {
                        syncedFields.add(new SyncedField.SyncedItemStack(te, field).setArrayIndex((int)var9_35).setLazy(isLazy));
                        ++var9_35;
                    }
                }
            }
            if (field.getType().isArray()) {
                for (ItemStackHandler obj : array = (Object[])o) {
                    syncedFields.addAll(NetworkUtils.getSyncedFields(obj, searchedAnnotation));
                }
            } else {
                syncedFields.addAll(NetworkUtils.getSyncedFields(o, searchedAnnotation));
            }
            if (syncedFields.size() > 0) {
                return syncedFields;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.warning("Field " + field + " didn't produce any syncable fields!", new Object[0]);
        return syncedFields;
    }

    private static SyncedField getSyncedFieldForField(Field field, Object te) {
        if (Integer.TYPE.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedInt(te, field);
        }
        if (Float.TYPE.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedFloat(te, field);
        }
        if (Double.TYPE.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedDouble(te, field);
        }
        if (Boolean.TYPE.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedBoolean(te, field);
        }
        if (String.class.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedString(te, field);
        }
        if (field.getType().isEnum()) {
            return new SyncedField.SyncedEnum(te, field);
        }
        if (ItemStack.class.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedItemStack(te, field);
        }
        if (FluidStack.class.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedFluidStack(te, field);
        }
        if (IItemHandlerModifiable.class.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedItemHandler(te, field);
        }
        return null;
    }
}

