/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsFrame;
import me.desht.pneumaticcraft.common.semiblock.ISpecificRequester;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class EntityLogisticsRequester
extends EntityLogisticsFrame
implements ISpecificRequester {
    private int minItems = 1;
    private int minFluid = 1;

    public EntityLogisticsRequester(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    public int getColor() {
        return -16776961;
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    protected ContainerType<?> getContainerType() {
        return (ContainerType)ModContainers.LOGISTICS_FRAME_REQUESTER.get();
    }

    public int getMinItemOrderSize() {
        return this.minItems;
    }

    public void setMinItemOrderSize(int minItems) {
        this.minItems = minItems;
    }

    public int getMinFluidOrderSize() {
        return this.minFluid;
    }

    public void setMinFluidOrderSize(int minFluid) {
        this.minFluid = minFluid;
    }

    @Override
    protected void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setMinItemOrderSize(tag.func_74762_e("minItems"));
        this.setMinFluidOrderSize(tag.func_74762_e("minFluid"));
    }

    @Override
    public CompoundNBT serializeNBT(CompoundNBT tag) {
        tag = super.serializeNBT(tag);
        tag.func_74768_a("minItems", this.getMinItemOrderSize());
        tag.func_74768_a("minFluid", this.getMinFluidOrderSize());
        return tag;
    }

    @Override
    public boolean canFilterStack() {
        return true;
    }

    @Override
    public boolean supportsBlacklisting() {
        return false;
    }

    @Override
    public void writeToBuf(PacketBuffer payload) {
        super.writeToBuf(payload);
        payload.func_150787_b(this.minItems);
        payload.func_150787_b(this.minFluid);
    }

    @Override
    public void readFromBuf(PacketBuffer payload) {
        super.readFromBuf(payload);
        this.minItems = payload.func_150792_a();
        this.minFluid = payload.func_150792_a();
    }

    @Override
    public int amountRequested(ItemStack stack) {
        int totalRequestingAmount = this.getTotalRequestedAmount(stack);
        if (totalRequestingAmount > 0) {
            return (Integer)IOHelper.getInventoryForTE(this.getCachedTileEntity(), this.getFacing()).map(itemHandler -> {
                int count = 0;
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack s = itemHandler.getStackInSlot(i);
                    if (s.func_190926_b() || !this.getItemFilterHandler().matchOneItem(s, stack)) continue;
                    count += s.func_190916_E();
                }
                return Math.max(0, Math.min(stack.func_190916_E(), totalRequestingAmount - (count += this.getIncomingItems(stack))));
            }).orElse((Object)0);
        }
        return 0;
    }

    @Override
    public int amountRequested(FluidStack stack) {
        int totalRequestingAmount = this.getTotalRequestedAmount(stack);
        if (totalRequestingAmount > 0) {
            return (Integer)this.getCachedTileEntity().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getFacing()).map(fluidHandler -> {
                int count = 0;
                for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                    FluidStack contents = fluidHandler.getFluidInTank(i);
                    if (contents.getFluid() != stack.getFluid()) continue;
                    count += contents.getAmount();
                }
                return Math.max(0, Math.min(stack.getAmount(), totalRequestingAmount - (count += this.getIncomingFluid(stack.getFluid()))));
            }).orElse((Object)0);
        }
        return 0;
    }

    private int getTotalRequestedAmount(ItemStack stack) {
        return this.getItemFilterHandler().getMatchedCount(stack);
    }

    private int getTotalRequestedAmount(FluidStack stack) {
        int requesting = 0;
        for (int i = 0; i < 9; ++i) {
            FluidStack requestingStack = this.getFluidFilter(i);
            if (requestingStack == null || requestingStack.getFluid() != stack.getFluid()) continue;
            requesting += requestingStack.getAmount();
        }
        return requesting;
    }
}

